/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import jp.naist.se.stigmata.ui.swing.GUIUtility;
import jp.naist.se.stigmata.ui.swing.Messages;

public class ChangeColorAction
extends AbstractAction {
    private static final long serialVersionUID = -7617597154707466764L;
    private Color currentColor = Color.RED;
    private JColorChooser chooser;
    private Component component;
    private boolean colorSelected = false;
    private ActionListener listener;

    public ChangeColorAction(String label, Component component, Color initialColor, ActionListener listener) {
        super(Messages.getString(String.valueOf(label) + ".label"), GUIUtility.getIcon(String.valueOf(label) + ".icon"));
        this.component = component;
        this.listener = listener;
        this.currentColor = initialColor;
        this.chooser = new JColorChooser();
        this.chooser.setColor(initialColor);
    }

    public ChangeColorAction(Component component, Color color, ActionListener listener) {
        this("changecolor", component, color, listener);
    }

    public ChangeColorAction(Component component, ActionListener listener) {
        this(component, Color.RED, listener);
    }

    public boolean isColorSelected() {
        return this.colorSelected;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void actionPerformed(ActionEvent e) {
        this.chooser.setColor(this.currentColor);
        JDialog dialog = JColorChooser.createDialog(this.component, Messages.getString("changecolor.title"), true, this.chooser, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangeColorAction.this.currentColor = ChangeColorAction.this.chooser.getColor();
                ChangeColorAction.this.colorSelected = true;
                ChangeColorAction.this.listener.actionPerformed(new ActionEvent(ChangeColorAction.this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangeColorAction.this.colorSelected = false;
            }
        });
        dialog.setVisible(true);
    }
}

