/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Component;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.naist.se.stigmata.ui.swing.Messages;

public class GUIUtility {
    private static final String iconPath = Messages.getString("icon.directory");

    private GUIUtility() {
    }

    public static void decorateJComponent(JComponent component, String label) {
        if (Messages.hasString(String.valueOf(label) + ".tooltip")) {
            component.setToolTipText(Messages.getString(String.valueOf(label) + ".tooltip"));
        }
        if (Messages.hasString(String.valueOf(label) + ".border")) {
            component.setBorder(new TitledBorder(Messages.getString(String.valueOf(label) + ".border")));
        }
        try {
            Icon icon = GUIUtility.getIcon(String.valueOf(label) + ".icon");
            if (icon != null) {
                Method[] methods;
                Method[] methodArray = methods = component.getClass().getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equals("setIcon")) {
                        m.invoke((Object)component, icon);
                    }
                    ++n2;
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public static JButton createButton(String label, Action action) {
        Icon icon;
        JButton button = new JButton(action);
        button.setText(Messages.getString(String.valueOf(label) + ".button.label"));
        button.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".button.tooltip")) {
            button.setToolTipText(Messages.getString(String.valueOf(label) + ".button.tooltip"));
        }
        if ((icon = GUIUtility.getIcon(String.valueOf(label) + ".button.icon")) != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JButton createButton(String label) {
        Icon icon;
        JButton button = new JButton(Messages.getString(String.valueOf(label) + ".button.label"));
        button.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".button.tooltip")) {
            button.setToolTipText(Messages.getString(String.valueOf(label) + ".button.tooltip"));
        }
        if ((icon = GUIUtility.getIcon(String.valueOf(label) + ".button.icon")) != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JCheckBoxMenuItem createJCheckBoxMenuItem(String label) {
        return GUIUtility.createJCheckBoxMenuItem(label, false);
    }

    public static JCheckBoxMenuItem createJCheckBoxMenuItem(String label, boolean status) {
        Icon icon;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString(String.valueOf(label) + ".menuitem.label"), status);
        item.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(String.valueOf(label) + ".menuitem.tooltip"));
        }
        if ((icon = GUIUtility.getIcon(String.valueOf(label) + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenuItem createJMenuItem(String label, Action action) {
        Icon icon;
        JMenuItem item = new JMenuItem(action);
        item.setText(Messages.getString(String.valueOf(label) + ".menuitem.label"));
        item.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(String.valueOf(label) + ".menuitem.tooltip"));
        }
        if ((icon = GUIUtility.getIcon(String.valueOf(label) + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenuItem createJMenuItem(String label) {
        Icon icon;
        JMenuItem item = new JMenuItem(Messages.getString(String.valueOf(label) + ".menuitem.label"));
        item.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(String.valueOf(label) + ".menuitem.tooltip"));
        }
        if ((icon = GUIUtility.getIcon(String.valueOf(label) + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenu createJMenu(String label) {
        Icon icon;
        JMenu menu = new JMenu(Messages.getString(String.valueOf(label) + ".menu.label"));
        menu.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menu.tooltip")) {
            menu.setToolTipText(Messages.getString(String.valueOf(label) + ".menu.tooltip"));
        }
        if ((icon = GUIUtility.getIcon(String.valueOf(label) + ".menu.icon")) != null) {
            menu.setIcon(icon);
        }
        return menu;
    }

    public static URL getResource(String resourcePathLabel, String resourcePathPrefix) {
        if (Messages.hasString(resourcePathLabel)) {
            String resourcePath = Messages.getString(resourcePathLabel);
            if (resourcePathPrefix != null) {
                resourcePath = String.valueOf(resourcePathPrefix) + resourcePath;
            }
            return GUIUtility.class.getResource(resourcePath);
        }
        return null;
    }

    public static URL getResource(String resourcePathLabel) {
        return GUIUtility.getResource(resourcePathLabel, null);
    }

    public static Icon getIcon(String label) {
        URL url = GUIUtility.getResource(label, iconPath);
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            return icon;
        }
        return null;
    }

    public static Image getImage(String imageFilePathLabel) {
        Icon icon = GUIUtility.getIcon(imageFilePathLabel);
        if (icon != null && icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return null;
    }

    public static void addNewTab(String key, JTabbedPane tabPane, Component comp) {
        GUIUtility.addNewTab(key, tabPane, comp, null, null);
    }

    public static void addNewTab(String key, JTabbedPane tabPane, Component comp, Object[] tabnameValues, Object[] values) {
        String tabName = Messages.getString(String.valueOf(key) + ".tab.label");
        String tooltip = Messages.getString(String.valueOf(key) + ".tab.tooltip");
        Icon icon = GUIUtility.getIcon(String.valueOf(key) + ".tab.icon");
        if (tabnameValues != null) {
            tabName = MessageFormat.format(tabName, tabnameValues);
        }
        if (values != null) {
            tooltip = MessageFormat.format(tooltip, values);
        }
        tabPane.addTab(tabName, icon, comp, tooltip);
    }
}

