/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result.history;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.result.XmlFileExtractionResultSet;
import jp.naist.se.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.naist.se.stigmata.utils.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFileExtractedBirthmarkHistory
implements ExtractedBirthmarkHistory {
    private File parent;
    private Map<String, File> files = new LinkedHashMap<String, File>();

    public XmlFileExtractedBirthmarkHistory() {
        this(new File(BirthmarkEnvironment.getStigmataHome(), "extracted_birthmarks"));
    }

    public XmlFileExtractedBirthmarkHistory(String path) {
        this(new File(path));
    }

    public XmlFileExtractedBirthmarkHistory(File parent) {
        this.parent = parent;
        this.refresh();
    }

    @Override
    public void refresh() {
        this.files.clear();
        File[] fileArray = this.parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isTarget(file)) {
                this.files.put(file.getName(), file);
            }
            ++n2;
        }
    }

    @Override
    public void deleteAllResultSets() {
        File[] fileArray = this.parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (this.isTarget(file)) {
                Utility.deleteDirectory(file);
            }
            ++n2;
        }
    }

    @Override
    public void deleteResultSet(String id) {
        File file = this.files.get(id);
        if (file != null) {
            if (file.isDirectory()) {
                Utility.deleteDirectory(file);
            } else {
                file.delete();
            }
        }
    }

    @Override
    public ExtractionResultSet getResultSet(String id) {
        File file = this.files.get(id);
        if (file != null) {
            return new XmlFileExtractionResultSet(file);
        }
        return null;
    }

    @Override
    public synchronized String[] getResultSetIds() {
        return this.files.keySet().toArray(new String[this.files.size()]);
    }

    @Override
    public Iterator<String> iterator() {
        return this.files.keySet().iterator();
    }

    private boolean isTarget(File file) {
        return file.isDirectory() && file.getName().matches("\\d\\d\\d\\d\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d.\\d\\d\\d");
    }
}

