/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ComparisonMethod;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.printer.xml.ExtractionResultSetXmlPrinter;
import jp.naist.se.stigmata.result.AbstractExtractionResultSet;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.utils.MultipleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFileExtractionResultSet
extends AbstractExtractionResultSet {
    private boolean addmode = true;
    private File storeDirectory;
    private Map<ExtractionTarget, XmlFile> files = new HashMap<ExtractionTarget, XmlFile>();

    XmlFileExtractionResultSet(BirthmarkContext context) {
        super(context);
    }

    XmlFileExtractionResultSet(BirthmarkContext context, File storeDirectory) {
        super(context);
        this.storeDirectory = storeDirectory;
    }

    public XmlFileExtractionResultSet(BirthmarkContext context, boolean tableType) {
        super(context, tableType);
    }

    public XmlFileExtractionResultSet(File directory) {
        super(Stigmata.getInstance().createContext());
        this.addmode = false;
        this.storeDirectory = directory;
        BirthmarkContext context = this.getContext();
        context.setStoreTarget(BirthmarkStoreTarget.XMLFILE);
        if (this.files.containsKey((Object)ExtractionTarget.TARGET_X) && this.files.containsKey((Object)ExtractionTarget.TARGET_Y)) {
            context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_XY);
        } else {
            context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_SAME_PAIR);
        }
        for (File file : this.storeDirectory.listFiles(new ExtensionFilter("xml"))) {
            String fileName = file.getName();
            String name = fileName.substring(0, fileName.lastIndexOf(46));
            ExtractionTarget et = ExtractionTarget.valueOf(name);
            if (et == null) continue;
            this.files.put(et, new XmlFile(file, context, false));
        }
    }

    @Override
    public void addBirthmarkSet(ExtractionTarget target, BirthmarkSet set) throws BirthmarkStoreException {
        XmlFile xml;
        if (this.addmode) {
            if (target == ExtractionTarget.TARGET_BOTH) {
                throw new IllegalArgumentException("unknown target: " + (Object)((Object)target));
            }
            xml = this.files.get((Object)target);
            if (xml == null) {
                xml = new XmlFile(new File(this.getStoreDirectory(), target.name() + ".xml"), this.getContext());
                this.files.put(target, xml);
            }
        } else {
            throw new BirthmarkStoreException("destination is already closed.");
        }
        xml.addBirthmarkSet(set);
    }

    @Override
    public Iterator<BirthmarkSet> birthmarkSets(ExtractionTarget target) {
        Iterator<BirthmarkSet> iterator;
        this.closeAllStream();
        XmlFile xml = this.files.get((Object)target);
        if (xml != null) {
            iterator = xml.birthmarkSets();
        } else if (target == ExtractionTarget.TARGET_BOTH) {
            MultipleIterator<BirthmarkSet> mi = new MultipleIterator<BirthmarkSet>();
            boolean addflag = false;
            if (this.files.containsKey((Object)ExtractionTarget.TARGET_X)) {
                addflag = true;
                mi.add(this.files.get((Object)ExtractionTarget.TARGET_X).birthmarkSets());
            }
            if (this.files.containsKey((Object)ExtractionTarget.TARGET_Y)) {
                addflag = true;
                mi.add(this.files.get((Object)ExtractionTarget.TARGET_Y).birthmarkSets());
            }
            if (!addflag && this.files.containsKey((Object)ExtractionTarget.TARGET_XY)) {
                mi.add(this.files.get((Object)ExtractionTarget.TARGET_XY).birthmarkSets());
            }
            iterator = mi;
        } else {
            iterator = null;
        }
        return iterator;
    }

    @Override
    public int getBirthmarkSetSize(ExtractionTarget target) {
        int size = 0;
        XmlFile xml = this.files.get((Object)target);
        if (xml != null) {
            size = xml.getBirthmarkSetSize();
        } else if (target == ExtractionTarget.TARGET_BOTH) {
            if (this.files.containsKey((Object)ExtractionTarget.TARGET_X)) {
                size += this.files.get((Object)ExtractionTarget.TARGET_X).getBirthmarkSetSize();
            }
            if (this.files.containsKey((Object)ExtractionTarget.TARGET_Y)) {
                size += this.files.get((Object)ExtractionTarget.TARGET_Y).getBirthmarkSetSize();
            }
            if (size == 0 && this.files.containsKey((Object)ExtractionTarget.TARGET_XY)) {
                size += this.files.get((Object)ExtractionTarget.TARGET_XY).getBirthmarkSetSize();
            }
        }
        return size;
    }

    @Override
    public BirthmarkStoreTarget getStoreTarget() {
        return BirthmarkStoreTarget.XMLFILE;
    }

    @Override
    public void removeAllBirthmarkSets(ExtractionTarget target) {
        XmlFile xml = this.files.get((Object)target);
        if (xml != null) {
            xml.removeAllBirthmarkSets();
        } else if (target == ExtractionTarget.TARGET_BOTH) {
            for (XmlFile file : this.files.values()) {
                file.removeAllBirthmarkSets();
            }
        }
    }

    @Override
    public void removeBirthmarkSet(ExtractionTarget target, BirthmarkSet set) {
        XmlFile xml = this.files.get((Object)target);
        if (xml != null) {
            xml.removeBirthmarkSet(set);
        } else if (target == ExtractionTarget.TARGET_BOTH) {
            throw new IllegalArgumentException("unknown target: " + (Object)((Object)target));
        }
    }

    private File getStoreDirectory() {
        if (this.storeDirectory == null) {
            this.storeDirectory = new File(BirthmarkEnvironment.getStigmataHome(), "extracted_birthmarks/" + XmlFileExtractionResultSet.generateId());
        }
        if (!this.storeDirectory.exists()) {
            this.storeDirectory.mkdirs();
        }
        return this.storeDirectory;
    }

    private void closeAllStream() {
        if (this.addmode) {
            this.addmode = false;
            for (XmlFile file : this.files.values()) {
                file.closeStream();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlFile {
        private ExtractionResultSetXmlPrinter formatter;
        private BirthmarkContext context;
        private List<URL> addList = new ArrayList<URL>();
        private int size;
        private File file;
        private PrintWriter out;

        public XmlFile(File file, BirthmarkContext context) {
            this.file = file;
            this.context = context;
        }

        public XmlFile(File file, BirthmarkContext context, boolean addflag) {
            this.file = file;
            this.context = context;
            if (!addflag) {
                this.addList = null;
            }
        }

        public void addBirthmarkSet(BirthmarkSet bs) throws BirthmarkStoreException {
            if (this.formatter == null) {
                try {
                    this.out = new PrintWriter(new FileWriter(this.file));
                    this.formatter = new ExtractionResultSetXmlPrinter();
                    this.formatter.printHeader(this.out);
                    this.out.printf("    <unit>%s</unit>%n", new Object[]{this.context.getExtractionUnit()});
                    this.out.printf("    <birthmark-types>%n", new Object[0]);
                    for (String type : this.context.getBirthmarkTypes()) {
                        this.out.printf("      <birthmark-type>%s</birthmark-type>%n", type);
                    }
                    this.out.printf("    </birthmark-types>%n", new Object[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out == null || this.formatter == null) {
                throw new BirthmarkStoreException("destination is closed on some reason");
            }
            ++this.size;
            this.addList.add(bs.getLocation());
            this.formatter.printBirthmarkSet(this.out, bs);
        }

        public Iterator<BirthmarkSet> birthmarkSets() {
            return new BirthmarkSetStAXIterator(this.file, this.addList, this.context);
        }

        public void closeStream() {
            if (this.formatter != null) {
                this.formatter.printFooter(this.out);
                this.out.close();
                this.out = null;
                this.formatter = null;
            }
        }

        public int getBirthmarkSetSize() {
            if (this.size == 0) {
                int s = 0;
                Iterator<BirthmarkSet> i = this.birthmarkSets();
                while (i.hasNext()) {
                    i.next();
                    ++s;
                }
                this.size = s;
            }
            return this.size;
        }

        public void removeAllBirthmarkSets() {
            this.file.delete();
            this.size = 0;
            this.addList.clear();
        }

        public void removeBirthmarkSet(BirthmarkSet set) {
            boolean removeFlag = this.addList.remove(set.getLocation());
            if (removeFlag) {
                --this.size;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BirthmarkSetStAXIterator
    implements Iterator<BirthmarkSet> {
        private XMLEventReader reader = null;
        private BirthmarkSet nextObject;
        private List<URL> validItems;
        private BirthmarkEnvironment env;
        private BirthmarkContext context;

        public BirthmarkSetStAXIterator(File file, List<URL> validItems, BirthmarkContext context) {
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                BufferedReader in = new BufferedReader(new FileReader(file));
                this.reader = factory.createXMLEventReader(in);
            }
            catch (FileNotFoundException e) {
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            this.validItems = validItems;
            this.context = context;
            this.env = context.getEnvironment();
            try {
                this.nextObject = this.findNext();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean hasNext() {
            boolean flag;
            boolean bl = flag = this.nextObject != null;
            if (!flag) {
                try {
                    this.reader.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            return flag;
        }

        @Override
        public BirthmarkSet next() {
            BirthmarkSet next = this.nextObject;
            try {
                this.nextObject = this.findNext();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            return next;
        }

        @Override
        public void remove() {
        }

        private BirthmarkSet findNext() throws XMLStreamException {
            BirthmarkSet nextObject = null;
            while ((nextObject = this.findNextImpl()) != null && this.validItems != null && !this.validItems.contains(nextObject.getLocation())) {
            }
            return nextObject;
        }

        private BirthmarkSet findNextImpl() throws XMLStreamException {
            String className = null;
            BirthmarkSet bs = null;
            Birthmark birthmark = null;
            BirthmarkSpi service = null;
            while (this.reader.hasNext()) {
                block12: {
                    EndElement ee;
                    XMLEvent event;
                    block10: {
                        String type;
                        String part;
                        StartElement se;
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block11: {
                                            event = this.reader.peek();
                                            if (!event.isStartElement()) break block10;
                                            se = event.asStartElement();
                                            part = se.getName().getLocalPart();
                                            if (!part.equals("unit")) break block11;
                                            ExtractionUnit unit = ExtractionUnit.valueOf(this.reader.getElementText());
                                            if (unit != null) {
                                                this.context.setExtractionUnit(unit);
                                            }
                                            break block12;
                                        }
                                        if (!part.equals("birthmark-type")) break block13;
                                        type = this.reader.getElementText();
                                        if (this.env.getService(type) != null) {
                                            this.context.addBirthmarkType(type);
                                        }
                                        break block12;
                                    }
                                    if (!part.equals("name")) break block14;
                                    className = this.reader.getElementText();
                                    break block12;
                                }
                                if (!part.equals("location")) break block15;
                                String location = this.reader.getElementText();
                                if (className == null || location == null) {
                                    throw new XMLStreamException("incompatible with definition");
                                }
                                try {
                                    URL url = new URL(location);
                                    bs = new BirthmarkSet(className, url);
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                                break block12;
                            }
                            if (!part.equals("element")) break block16;
                            if (service != null) {
                                BirthmarkElement be = service.buildBirthmarkElement(this.reader.getElementText());
                                birthmark.addElement(be);
                            }
                            break block12;
                        }
                        if (!part.equals("birthmark")) break block12;
                        type = se.getAttributeByName(new QName("type")).getValue();
                        service = this.env.getService(type);
                        if (service != null) {
                            birthmark = service.buildBirthmark();
                            bs.addBirthmark(birthmark);
                        } else {
                            birthmark = null;
                        }
                        break block12;
                    }
                    if (event.isEndElement() && (ee = event.asEndElement()).getName().getLocalPart().equals("extracted-birthmark")) {
                        this.reader.nextEvent();
                        break;
                    }
                }
                this.reader.nextEvent();
            }
            return bs;
        }
    }
}

