/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.result.AbstractComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinComparisonResultSet
extends AbstractComparisonResultSet {
    private int compareCount = -1;
    private boolean tableType;
    private boolean samePair = false;

    public RoundRobinComparisonResultSet(ExtractionResultSet resultset) {
        this(resultset, false);
    }

    public RoundRobinComparisonResultSet(ExtractionResultSet resultset, boolean samePair) {
        super(resultset);
        this.tableType = resultset.isTableType();
        this.setCompareSamePair(samePair);
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.extraction.getEnvironment();
    }

    @Override
    public BirthmarkContext getContext() {
        return this.extraction.getContext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCompareSamePair(boolean flag) {
        this.samePair = flag;
        if (!this.extraction.isTableType()) {
            int size = this.extraction.getBirthmarkSetSize(ExtractionTarget.TARGET_XY);
            if (flag) {
                if (size > 1) {
                    this.compareCount = (size - 1) * (size - 2) + 1;
                    return;
                } else {
                    if (size != 1) throw new IllegalStateException("no extraction result");
                    this.compareCount = 0;
                }
                return;
            } else if (size > 1) {
                this.compareCount = (size - 1) * (size - 2) + 1 + size;
                return;
            } else {
                if (size != 1) throw new IllegalStateException("no extraction result");
                this.compareCount = 1;
            }
            return;
        } else {
            if (this.compareCount != -1) return;
            this.compareCount = this.extraction.getBirthmarkSetSize(ExtractionTarget.TARGET_X) * this.extraction.getBirthmarkSetSize(ExtractionTarget.TARGET_Y);
        }
    }

    public boolean isCompareSamePair() {
        return this.samePair;
    }

    @Override
    public int getPairCount() {
        return this.compareCount;
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        if (this.tableType) {
            return new CompareTableIterator();
        }
        return new CompareTriangleIterator();
    }

    @Override
    public BirthmarkSet[] getPairSources() {
        ArrayList<BirthmarkSet> list = new ArrayList<BirthmarkSet>();
        Iterator<BirthmarkSet> i = this.pairSources();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list.toArray(new BirthmarkSet[list.size()]);
    }

    @Override
    public Iterator<BirthmarkSet> pairSources() {
        HashMap<URL, BirthmarkSet> map = new HashMap<URL, BirthmarkSet>();
        if (this.extraction.isTableType()) {
            BirthmarkSet bs;
            Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
            while (i.hasNext()) {
                bs = i.next();
                map.put(bs.getLocation(), bs);
            }
            i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
            while (i.hasNext()) {
                bs = i.next();
                map.put(bs.getLocation(), bs);
            }
        } else {
            Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_XY);
            while (i.hasNext()) {
                BirthmarkSet bs = i.next();
                map.put(bs.getLocation(), bs);
            }
        }
        return map.values().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareTableIterator
    implements Iterator<ComparisonPair> {
        private Iterator<BirthmarkSet> ix;
        private Iterator<BirthmarkSet> iy;
        private BirthmarkSet x;

        private CompareTableIterator() {
            this.ix = RoundRobinComparisonResultSet.this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
            this.iy = RoundRobinComparisonResultSet.this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
            this.x = this.ix.next();
        }

        @Override
        public boolean hasNext() {
            return this.ix.hasNext() || this.iy.hasNext();
        }

        @Override
        public ComparisonPair next() {
            if (!this.iy.hasNext()) {
                this.iy = RoundRobinComparisonResultSet.this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
                this.x = this.ix.next();
            }
            BirthmarkSet y = this.iy.next();
            return new ComparisonPair(this.x, y, RoundRobinComparisonResultSet.this.extraction.getContext());
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareTriangleIterator
    implements Iterator<ComparisonPair> {
        private List<String> names = new ArrayList<String>();
        private Iterator<BirthmarkSet> iterator;
        private int index = 0;
        private BirthmarkSet bs;
        private ComparisonPair next;

        public CompareTriangleIterator() {
            this.iterator = RoundRobinComparisonResultSet.this.extraction.birthmarkSets(ExtractionTarget.TARGET_XY);
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ComparisonPair next() {
            ComparisonPair returnValue = this.next;
            this.next = this.findNext();
            return returnValue;
        }

        private ComparisonPair findNext() {
            if (this.bs == null && this.iterator.hasNext()) {
                this.bs = this.iterator.next();
                this.names.add(this.bs.getName());
            }
            if (RoundRobinComparisonResultSet.this.isCompareSamePair() && this.index == this.names.size() || !RoundRobinComparisonResultSet.this.isCompareSamePair() && this.index == this.names.size() - 1) {
                this.index = 0;
                if (this.iterator.hasNext()) {
                    this.bs = this.iterator.next();
                    this.names.add(this.bs.getName());
                } else {
                    return null;
                }
            }
            String name = this.names.get(this.index);
            BirthmarkSet bsX = RoundRobinComparisonResultSet.this.extraction.getBirthmarkSet(ExtractionTarget.TARGET_XY, name);
            ComparisonPair pair = null;
            if (bsX != null) {
                pair = new ComparisonPair(bsX, this.bs, RoundRobinComparisonResultSet.this.extraction.getContext());
            }
            ++this.index;
            if (pair == null) {
                pair = this.findNext();
            }
            return pair;
        }

        @Override
        public void remove() {
        }
    }
}

