/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.result.AbstractExtractionResultSet;
import jp.naist.se.stigmata.utils.ArrayIterator;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDBExtractionResultSet
extends AbstractExtractionResultSet {
    private String id;
    private DataSource source;
    private boolean initFlag = true;

    public RDBExtractionResultSet(BirthmarkContext context) {
        super(context);
        this.initializeDataSource();
    }

    public RDBExtractionResultSet(DataSource source, String id) {
        super(Stigmata.getInstance().createContext());
        this.source = source;
        this.id = id;
        this.initializeDataSource();
        this.initialization(this.getContext());
    }

    @Override
    public String[] getBirthmarkTypes() {
        if (this.initFlag) {
            String[] types = (String[])this.select("SELECT TYPE FROM EXTRACTED_BIRTHMARK_TYPES WHERE EXTRACTED_ID = ?", new StringHandler(), this.id);
            if (types == null) {
                types = new String[]{};
            }
            return types;
        }
        return super.getBirthmarkTypes();
    }

    @Override
    public ExtractionUnit getExtractionUnit() {
        if (this.initFlag) {
            String[] units = (String[])this.select("SELECT UNIT FROM EXTRACTED_BIRTHMARKS WHERE EXTRACTED_ID = ?", new StringHandler(), this.id);
            if (units != null && units.length > 0) {
                return ExtractionUnit.valueOf(units[0]);
            }
            return ExtractionUnit.CLASS;
        }
        return super.getExtractionUnit();
    }

    @Override
    public void addBirthmarkSet(ExtractionTarget target, BirthmarkSet set) throws BirthmarkStoreException {
    }

    @Override
    public BirthmarkSet[] getBirthmarkSets(ExtractionTarget target) {
        return (BirthmarkSet[])this.select("SELECT * FROM EXTRACTED_BIRTHMARK WHERE EXTRACTED_ID = ? AND STORE_TARGET = ? ORDER TO TYPE, INDEX", new BirthmarkSetListHandler(this.getEnvironment()), this.id, target.name());
    }

    @Override
    public Iterator<BirthmarkSet> birthmarkSets(ExtractionTarget target) {
        return new ArrayIterator<BirthmarkSet>(this.getBirthmarkSets(target));
    }

    @Override
    public int getBirthmarkSetSize(ExtractionTarget target) {
        Integer o = (Integer)this.select("SELECT DISTINCT COUNT(LOCATION) FROM EXTRACTED_BIRTHMARK WEHERE ID=? and STORE_TARGET=?", (ResultSetHandler)new ScalarHandler(), this.id, target.name());
        return o;
    }

    @Override
    public void removeAllBirthmarkSets(ExtractionTarget target) {
        QueryRunner qr = new QueryRunner(this.source);
        try {
            qr.update("DELETE FROM EXTRACTED_BIRTHMARK WHERE ID=? and STORE_TARGET=?", new Object[]{this.id, target.name()});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void removeBirthmarkSet(ExtractionTarget target, BirthmarkSet set) {
        QueryRunner qr = new QueryRunner(this.source);
        try {
            qr.update("DELETE FROM EXTRACTED_BIRTHMARK WHERE ID=? and LOCATION=? and STORE_TARGET=?", new Object[]{this.id, set.getLocation(), target.name()});
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public BirthmarkStoreTarget getStoreTarget() {
        return BirthmarkStoreTarget.RDB;
    }

    private Object select(String sql, ResultSetHandler handler, Object ... parameters) {
        QueryRunner qr = new QueryRunner(this.source);
        try {
            return qr.query(sql, parameters, handler);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private void initialization(BirthmarkContext context) {
        context.setStoreTarget(BirthmarkStoreTarget.RDB);
        context.setBirthmarkTypes(this.getBirthmarkTypes());
        context.setExtractionUnit(this.getExtractionUnit());
        this.initFlag = false;
    }

    private void initializeDataSource() {
        try {
            InitialContext namingContext = new InitialContext();
            String dataSourceName = this.getEnvironment().getProperty("rdb.datasource");
            if (dataSourceName == null) {
                throw new IllegalStateException("property ``rdb.datasource''  is missing");
            }
            this.source = (DataSource)namingContext.lookup(dataSourceName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private static class BirthmarkSetListHandler
    implements ResultSetHandler {
        private BirthmarkEnvironment env;

        public BirthmarkSetListHandler(BirthmarkEnvironment env) {
            this.env = env;
        }

        public Object handle(ResultSet rs) throws SQLException {
            HashMap<URL, BirthmarkSet> map = new HashMap<URL, BirthmarkSet>();
            while (rs.next()) {
                try {
                    String type;
                    Birthmark birthmark;
                    String name = rs.getString("NAME");
                    String location = rs.getString("LOCATION");
                    URL url = new URL(location);
                    BirthmarkSet bs = (BirthmarkSet)map.get(url);
                    if (bs == null) {
                        bs = new BirthmarkSet(name, url);
                        map.put(url, bs);
                    }
                    if ((birthmark = bs.getBirthmark(type = rs.getString("TYPE"))) == null) {
                        birthmark = this.env.getService(type).buildBirthmark();
                        bs.addBirthmark(birthmark);
                    }
                    String element = rs.getString("ELEMENT");
                    birthmark.addElement(this.env.getService(type).buildBirthmarkElement(element));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return map.values().toArray(new BirthmarkSet[map.size()]);
        }
    }

    public static class StringHandler
    implements ResultSetHandler {
        private int index;

        public StringHandler() {
            this(0);
        }

        public StringHandler(int index) {
            this.index = index;
        }

        public Object handle(ResultSet rs) throws SQLException {
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(this.index));
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

