/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.kgram;

import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.birthmarks.AbstractBirthmarkService;
import jp.naist.se.stigmata.birthmarks.comparators.LogicalAndBirthmarkComparator;
import jp.naist.se.stigmata.birthmarks.kgram.KGram;
import jp.naist.se.stigmata.birthmarks.kgram.KGramBasedBirthmarkElement;
import jp.naist.se.stigmata.birthmarks.kgram.KGramBasedBirthmarkExtractor;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class KGramBasedBirthmarkService
extends AbstractBirthmarkService
implements BirthmarkSpi {
    private BirthmarkComparator comparator = new LogicalAndBirthmarkComparator(this);
    private BirthmarkExtractor extractor = new KGramBasedBirthmarkExtractor(this);

    public String getType() {
        return "kgram";
    }

    public String getDefaultDescription() {
        return "k-gram based birthmark.";
    }

    public BirthmarkExtractor getExtractor() {
        return this.extractor;
    }

    public BirthmarkComparator getComparator() {
        return this.comparator;
    }

    public boolean isExpert() {
        return false;
    }

    public boolean isUserDefined() {
        return false;
    }

    public BirthmarkElement buildBirthmarkElement(String value) {
        if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
            String[] param = value.substring(1, value.length() - 1).split(", *");
            KGram<Integer> kgram = new KGram<Integer>(param.length);
            int i = 0;
            while (i < param.length) {
                kgram.set(i, new Integer(param[i].trim()));
                ++i;
            }
            return new KGramBasedBirthmarkElement(kgram);
        }
        return null;
    }
}

