/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.kgram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.birthmarks.kgram.KGram;
import jp.naist.se.stigmata.birthmarks.kgram.KGramBasedBirthmarkElement;
import jp.naist.se.stigmata.birthmarks.kgram.OpcodeExtractionMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class KGramBasedBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    private int kvalue;
    private List<Integer> opcodes = new ArrayList<Integer>();

    public KGramBasedBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkEnvironment environment) {
        super(visitor, birthmark, environment);
    }

    public int getKValue() {
        return this.kvalue;
    }

    public void setKValue(int kvalue) {
        this.kvalue = kvalue;
    }

    public void visitEnd() {
        HashSet kgrams = new HashSet();
        if (this.opcodes.size() >= this.getKValue()) {
            int n = this.getKValue();
            int max = this.opcodes.size() - (n - 1);
            int i = 0;
            while (i < max) {
                KGram<Integer> kgram = new KGram<Integer>(n);
                int j = 0;
                while (j < n) {
                    kgram.set(j, this.opcodes.get(i + j));
                    ++j;
                }
                kgrams.add(kgram);
                ++i;
            }
        }
        for (KGram kGram : kgrams) {
            this.addElement(new KGramBasedBirthmarkElement(kGram));
        }
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        MethodVisitor visitor = super.visitMethod(arg0, arg1, arg2, arg3, arg4);
        OpcodeExtractionMethodVisitor opcodeVisitor = new OpcodeExtractionMethodVisitor(visitor, this.opcodes);
        return opcodeVisitor;
    }
}

