/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.is;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.birthmarks.NullBirthmarkElement;
import jp.naist.se.stigmata.utils.WellknownClassManager;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceStructureBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    public InheritanceStructureBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkEnvironment environment) {
        super(visitor, birthmark, environment);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        try {
            Class<?> c = this.getEnvironment().getClasspathContext().findClass(name.replace('/', '.'));
            if (c != null && !c.isInterface()) {
                this.addISBirthmark(c);
            }
        }
        catch (ClassNotFoundException ex) {
            this.addFailur(ex);
        }
    }

    private void addISBirthmark(Class<?> c) {
        WellknownClassManager wcm = this.getEnvironment().getWellknownClassManager();
        do {
            String className = c.getName();
            BirthmarkElement element = null;
            element = wcm.isWellKnownClass(className) ? new BirthmarkElement(className) : NullBirthmarkElement.getInstance();
            this.addElement(element);
        } while (!(c = c.getSuperclass()).getName().equals("java.lang.Object"));
        this.addElement(new BirthmarkElement("java.lang.Object"));
    }
}

