/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.cvfv;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import jp.naist.se.stigmata.BirthmarkElement;

public class TypeAndValueBirthmarkElement
extends BirthmarkElement
implements Serializable {
    private static final long serialVersionUID = 237098465735321L;
    private String signature;
    private Serializable serialValue;
    private transient Object value;

    public TypeAndValueBirthmarkElement(String signature, Object value) {
        super(String.valueOf(signature) + "=" + value);
        this.signature = signature;
        this.setValue(value);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setValue(Object value) {
        this.value = value;
        if (this.signature.length() == 1 && value == null) {
            switch (this.signature.charAt(0)) {
                case 'Z': {
                    value = Boolean.FALSE;
                    break;
                }
                case 'D': {
                    value = new Double(0.0);
                    break;
                }
                case 'F': {
                    value = new Float(0.0f);
                    break;
                }
                default: {
                    value = new Integer(0);
                }
            }
        }
        if (value != null && value instanceof Serializable) {
            this.serialValue = (Serializable)value;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.signature) + "=" + this.value;
    }

    public int hashCode() {
        return this.signature.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TypeAndValueBirthmarkElement) {
            TypeAndValueBirthmarkElement tvbe = (TypeAndValueBirthmarkElement)o;
            if (this.getSignature().equals(tvbe.getSignature())) {
                if (this.getValue() == null && tvbe.getValue() == null) {
                    return true;
                }
                if (this.getValue() != null && tvbe.getValue() != null) {
                    return this.getValue().equals(tvbe.getValue());
                }
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serialValue != null) {
            this.value = this.serialValue;
        }
    }
}

