/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.ApplicationInitializationError;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEngine;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.event.BirthmarkEngineListener;
import jp.naist.se.stigmata.printer.PrinterManager;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.utils.ConfigFileExporter;
import jp.naist.se.stigmata.utils.ConfigFileImporter;

public class Stigmata {
    private static Stigmata stigmata;
    private BirthmarkEnvironment defaultEnvironment;
    private List<BirthmarkEngineListener> listeners = new ArrayList<BirthmarkEngineListener>();

    private Stigmata() {
        this.configuration();
    }

    public static synchronized Stigmata getInstance() {
        if (stigmata == null) {
            stigmata = new Stigmata();
        }
        return stigmata;
    }

    public BirthmarkContext createContext() {
        return new BirthmarkContext(this.createEnvironment());
    }

    public BirthmarkEnvironment createEnvironment() {
        return new BirthmarkEnvironment(this.defaultEnvironment);
    }

    public BirthmarkEngine createEngine() {
        return this.createEngine(this.createEnvironment());
    }

    public BirthmarkEngine createEngine(BirthmarkEnvironment environment) {
        BirthmarkEngine engine = new BirthmarkEngine(environment);
        for (BirthmarkEngineListener listener : this.listeners) {
            engine.addBirthmarkEngineListener(listener);
        }
        return engine;
    }

    public void addBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.add(listener);
    }

    public void removeBirthmarkEngineListener(BirthmarkEngineListener listener) {
        this.listeners.remove(listener);
    }

    public void configuration() {
        this.configuration(null, false);
    }

    public void configuration(String filePath, boolean resetFlag) {
        InputStream target = null;
        if (filePath != null) {
            try {
                target = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                filePath = null;
            }
        }
        if (filePath == null) {
            File file;
            String currentDirectory = System.getProperty("execution.directory");
            if (currentDirectory == null) {
                currentDirectory = System.getProperty("user.dir");
            }
            if (!(file = new File(currentDirectory, "stigmata.xml")).exists() && !(file = new File(BirthmarkEnvironment.getStigmataHome(), "stigmata.xml")).exists()) {
                file = null;
            }
            if (file != null) {
                try {
                    target = new FileInputStream(file);
                }
                catch (FileNotFoundException ex) {
                    throw new InternalError(ex.getMessage());
                }
            }
        }
        if (target == null || resetFlag) {
            target = this.getClass().getResourceAsStream("/resources/stigmata.xml");
            if (resetFlag) {
                this.defaultEnvironment = null;
                BirthmarkEnvironment.resetSettings();
            }
        }
        this.initConfiguration(target);
    }

    private void initConfiguration(InputStream in) {
        if (this.defaultEnvironment == null) {
            this.defaultEnvironment = BirthmarkEnvironment.getDefaultEnvironment();
        }
        this.buildStigmataDirectory(BirthmarkEnvironment.getStigmataHome());
        this.defaultEnvironment.setClassLoader(Stigmata.buildClassLoader("plugins"));
        try {
            ConfigFileImporter parser = new ConfigFileImporter(this.defaultEnvironment);
            parser.parse(in);
        }
        catch (IOException e) {
            throw new ApplicationInitializationError(e);
        }
        Iterator<BirthmarkSpi> i = this.defaultEnvironment.lookupProviders(BirthmarkSpi.class);
        while (i.hasNext()) {
            BirthmarkSpi service = i.next();
            this.defaultEnvironment.addService(service);
        }
        PrinterManager.updateServices(this.defaultEnvironment);
        this.exportConfigFile(BirthmarkEnvironment.getStigmataHome(), "stigmata.xml");
    }

    private void buildStigmataDirectory(String homeDirectory) {
        File pluginDir;
        File file = new File(homeDirectory);
        if (file.exists() && file.isFile()) {
            File dest = new File(file.getParent(), ".stigmata.back");
            file.renameTo(dest);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(pluginDir = new File(file, "plugins")).exists()) {
            pluginDir.mkdirs();
        }
    }

    private void exportConfigFile(String parent, String fileName) {
        try {
            File file = new File(parent, fileName);
            if (!file.exists()) {
                ConfigFileExporter exporter = new ConfigFileExporter(this.defaultEnvironment);
                exporter.export(new PrintWriter(new FileWriter(file)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ClassLoader buildClassLoader(String path) {
        File directory = new File(BirthmarkEnvironment.getStigmataHome(), path);
        File[] jarfiles = directory.listFiles(new ExtensionFilter("jar"));
        if (jarfiles == null) {
            jarfiles = new File[]{};
        }
        try {
            URL[] urls = new URL[jarfiles.length];
            int i = 0;
            while (i < jarfiles.length) {
                urls[i] = jarfiles[i].toURI().toURL();
                ++i;
            }
            return new URLClassLoader(urls, Stigmata.class.getClassLoader());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

