/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.naist.se.stigmata.Birthmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthmarkSet
implements Iterable<Birthmark> {
    private String name;
    private URL location;
    private Map<String, Birthmark> birthmarks = new HashMap<String, Birthmark>();

    public BirthmarkSet(String name, URL location) {
        this.name = name;
        this.location = location;
    }

    public int getSumOfElementCount() {
        int count = 0;
        Iterator<String> i = this.birthmarkTypes();
        while (i.hasNext()) {
            Birthmark birthmark = this.getBirthmark(i.next());
            count += birthmark.getElementCount();
        }
        return count;
    }

    public int getBirthmarksCount() {
        return this.birthmarks.size();
    }

    public String getName() {
        return this.name;
    }

    public URL getLocation() {
        return this.location;
    }

    public void addBirthmark(Birthmark birthmark) {
        if (birthmark == null) {
            throw new NullPointerException("given birthmark is null");
        }
        this.birthmarks.put(birthmark.getType(), birthmark);
    }

    public Birthmark getBirthmark(String type) {
        return this.birthmarks.get(type);
    }

    public boolean hasBirthmark(String type) {
        return this.birthmarks.get(type) != null;
    }

    public Birthmark[] getBirthmarks() {
        Birthmark[] b = new Birthmark[this.getBirthmarksCount()];
        int index = 0;
        Iterator<String> i = this.birthmarkTypes();
        while (i.hasNext()) {
            b[index] = this.getBirthmark(i.next());
            ++index;
        }
        return b;
    }

    @Override
    public Iterator<Birthmark> iterator() {
        return this.birthmarks.values().iterator();
    }

    public Iterator<String> birthmarkTypes() {
        return this.birthmarks.keySet().iterator();
    }

    public synchronized String[] getBirthmarkTypes() {
        return this.birthmarks.keySet().toArray(new String[this.birthmarks.size()]);
    }
}

