/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli;

import java.io.FileInputStream;
import java.io.IOException;
import jp.sourceforge.talisman.xmlcli.OptionsBuilder;
import jp.sourceforge.talisman.xmlcli.XmlCliConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.OptionsBuilderFactory;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class XmlCli {
    private Options options;

    public XmlCli(String xmlfile) {
        this.parseOptions(xmlfile);
    }

    public Options getOptions() {
        return this.options;
    }

    public void printHelp() {
        this.printHelp("syntax");
    }

    public void printHelp(String syntax) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(syntax, this.options);
    }

    private void parseOptions(String file) {
        try {
            OptionsBuilderFactory factory = OptionsBuilderFactory.getInstance();
            OptionsBuilder builder = factory.createBuilder(new FileInputStream(file));
            this.options = builder.buildOptions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlCliConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        for (String arg : args) {
            new XmlCli(arg).printHelp();
        }
    }
}

