/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleIterator<T>
implements Iterator<T> {
    private List<Iterator<T>> iterators = new ArrayList<Iterator<T>>();
    private int index = 0;
    private Iterator<T> current;
    private boolean finished = false;

    public MultipleIterator() {
    }

    public MultipleIterator(Iterator<T>[] iteratorArray) {
        Iterator<T>[] iteratorArray2 = iteratorArray;
        int n = iteratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Iterator<T> iterator = iteratorArray2[n2];
            this.iterators.add(iterator);
            ++n2;
        }
    }

    public MultipleIterator(Iterator<Iterator<T>> iterator) {
        while (iterator.hasNext()) {
            this.iterators.add(iterator.next());
        }
    }

    public MultipleIterator(Collection<Iterator<T>> collection) {
        this(collection.iterator());
    }

    public void add(Iterator<T> iterator) {
        this.iterators.add(iterator);
    }

    public void remove(Iterator<T> iterator) {
        this.iterators.remove(iterator);
    }

    private void nextIterator() {
        if (this.index >= this.iterators.size()) {
            this.current = null;
            this.finished = true;
            return;
        }
        this.current = this.iterators.get(this.index);
        ++this.index;
    }

    @Override
    public void remove() {
        this.current.remove();
    }

    @Override
    public boolean hasNext() {
        boolean flag;
        if (this.current == null) {
            this.nextIterator();
        }
        if (!(flag = this.current.hasNext())) {
            this.nextIterator();
        }
        return this.finished || this.current.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }
}

