/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import Jama.Matrix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.result.SingleExtractionResultSet;
import jp.naist.se.stigmata.ui.swing.ClippedLRListCellRenderer;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PopupButton;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.ChangeColorAction;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;
import jp.naist.se.stigmata.ui.swing.mds.GeometoryType;
import jp.naist.se.stigmata.ui.swing.mds.LabelMap;
import jp.naist.se.stigmata.ui.swing.mds.MDSGraphViewer;
import jp.naist.se.stigmata.ui.swing.mds.MDSImageExporter;
import jp.naist.se.stigmata.ui.swing.mds.MDSMethod;
import jp.naist.se.stigmata.ui.swing.mds.MDSPointsLocationExporter;
import jp.naist.se.stigmata.ui.swing.mds.mark.DrawerFactory;

public class MDSGraphPanel
extends JPanel {
    private static final long serialVersionUID = -7256554014379112897L;
    private StigmataFrame stigmata;
    private BirthmarkSet[] set;
    private BirthmarkContext context;
    private LabelMap labels;
    private MDSGraphViewer viewer;

    public MDSGraphPanel(StigmataFrame stigmata, BirthmarkSet[] set, BirthmarkContext context) {
        this.stigmata = stigmata;
        this.context = context;
        this.set = set;
        double[][] matrix = this.initData(set, context);
        this.initLayouts(matrix);
    }

    private double[][] initData(BirthmarkSet[] set, BirthmarkContext context) {
        this.labels = new LabelMap();
        double[][] matrix = new double[set.length][set.length];
        int i = 0;
        while (i < set.length) {
            int j = 0;
            while (j <= i) {
                ComparisonPair pair = new ComparisonPair(set[i], set[j], context);
                matrix[i][j] = 1.0 - pair.calculateSimilarity();
                if (i != j) {
                    matrix[j][i] = matrix[i][j];
                }
                ++j;
            }
            String className = set[i].getName();
            this.labels.addLabel(className);
            String groupName = this.getGroupName(set[i].getLocation());
            this.labels.setGroup(className, groupName);
            ++i;
        }
        return matrix;
    }

    private String getGroupName(URL location) {
        String url = location.toString();
        if (url.startsWith("jar:")) {
            url = url.substring("jar:".length(), url.lastIndexOf(33));
        }
        return url;
    }

    private void initLayouts(double[][] matrix) {
        this.viewer = new MDSGraphViewer(new MDSMethod(new Matrix(matrix)), this.labels);
        this.viewer.setShowLabel(true);
        this.viewer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String c = e.getActionCommand();
                int i = 0;
                while (i < MDSGraphPanel.this.set.length) {
                    if (c.equals(MDSGraphPanel.this.set[i].getName())) {
                        SingleExtractionResultSet ers = new SingleExtractionResultSet(MDSGraphPanel.this.context, MDSGraphPanel.this.set[i]);
                        MDSGraphPanel.this.stigmata.showExtractionResult(ers);
                    }
                    ++i;
                }
            }
        });
        JCheckBox check = new JCheckBox(Messages.getString("showlabel.button.label"), true);
        check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox c = (JCheckBox)e.getSource();
                MDSGraphPanel.this.viewer.setShowLabel(c.isSelected());
            }
        });
        ChangeColorAction pointColorAction = new ChangeColorAction("updatecolor", this.stigmata, Color.BLACK, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangeColorAction action = (ChangeColorAction)e.getSource();
                MDSGraphPanel.this.viewer.setPointColor(action.getColor());
            }
        });
        ChangeColorAction overColorAction = new ChangeColorAction("updateovercolor", this.stigmata, Color.BLUE, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChangeColorAction action = (ChangeColorAction)e.getSource();
                MDSGraphPanel.this.viewer.setOverColor(action.getColor());
            }
        });
        SaveAction saveMDSAction = new SaveAction(this.stigmata, new MDSImageExporter(this.viewer));
        saveMDSAction.setExtensions(Messages.getStringArray("savemds.extensions"));
        saveMDSAction.setDescrpition(Messages.getString("savemds.description"));
        SaveAction saveCoordinate = new SaveAction(this.stigmata, new MDSPointsLocationExporter(this.viewer));
        saveCoordinate.setExtensions(Messages.getStringArray("savelocation.extensions"));
        saveCoordinate.setDescrpition(Messages.getString("savelocation.description"));
        PopupButton colorButton = new PopupButton(Utility.createButton("updatecolor", pointColorAction));
        colorButton.addMenuItem(Utility.createJMenuItem("updateovercolor", overColorAction));
        PopupButton saveButton = new PopupButton(Utility.createButton("savemds", saveMDSAction));
        saveButton.addMenuItem(Utility.createJMenuItem("savelocation", saveCoordinate));
        JLabel numberOfDotsLabel = new JLabel(String.valueOf(this.set.length));
        Utility.decorateJComponent(numberOfDotsLabel, "mdsgraph.count");
        JComboBox<ClippedLRListCellRenderer.LRItem> numberOfGroupsLabelCombo = new JComboBox<ClippedLRListCellRenderer.LRItem>();
        GeometoryType[] types = GeometoryType.values();
        DrawerFactory factory = DrawerFactory.getInstance();
        String[] stringArray = this.labels.getGroupNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            int count = this.labels.getGroupElementCount(name);
            if (count != 0) {
                ClippedLRListCellRenderer.LRItem item = new ClippedLRListCellRenderer.LRItem(name, count);
                item.setIcon(factory.createIcon(types[this.labels.getGroupId(name)]));
                numberOfGroupsLabelCombo.addItem(item);
            }
            ++n2;
        }
        numberOfGroupsLabelCombo.setEditable(false);
        Dimension dim = new Dimension(100, numberOfGroupsLabelCombo.getPreferredSize().height);
        numberOfGroupsLabelCombo.setRenderer(new ClippedLRListCellRenderer(dim, 50));
        Utility.decorateJComponent(numberOfGroupsLabelCombo, "mdsgraph.group");
        JPanel north = new JPanel(new GridLayout(1, 2));
        north.add(numberOfDotsLabel);
        north.add(numberOfGroupsLabelCombo);
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(saveButton);
        south.add(Box.createHorizontalGlue());
        south.add(colorButton);
        south.add(Box.createHorizontalGlue());
        south.add(check);
        south.add(Box.createHorizontalGlue());
        JPanel center = new JPanel(new FlowLayout(1));
        center.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension d = e.getComponent().getSize();
                MDSGraphPanel.this.viewer.setSize(d.width - 10, d.height - 10);
            }
        });
        this.setLayout(new BorderLayout());
        center.add(this.viewer);
        this.add((Component)north, "North");
        this.add((Component)center, "Center");
        this.add((Component)south, "South");
    }
}

