/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.UnsupportedFormatException;
import jp.naist.se.stigmata.utils.AsciiDataWritable;
import jp.naist.se.stigmata.utils.BinaryDataWritable;

public class SaveAction
extends AbstractAction {
    private static final long serialVersionUID = 1427912047636729211L;
    private AsciiDataWritable asciiWritable;
    private BinaryDataWritable binaryWritable;
    private StigmataFrame stigmata;
    private String[] extensions;
    private String description;

    public SaveAction(StigmataFrame stigmata, AsciiDataWritable writable) {
        this.stigmata = stigmata;
        this.asciiWritable = writable;
    }

    public SaveAction(StigmataFrame stigmata, BinaryDataWritable writable) {
        this.stigmata = stigmata;
        this.binaryWritable = writable;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public void setDescrpition(String description) {
        this.description = description;
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        if (this.extensions == null || this.description == null) {
            this.extensions = Messages.getStringArray("store.extensions");
            this.description = Messages.getString("store.description");
        }
        if ((file = this.stigmata.getSaveFile(this.extensions, this.description)) != null) {
            String name = file.getName();
            String format = name.substring(name.lastIndexOf(46) + 1, name.length());
            OutputStream out = null;
            PrintWriter writer = null;
            try {
                try {
                    if (this.asciiWritable != null) {
                        writer = new PrintWriter(new FileWriter(file));
                        this.asciiWritable.writeAsciiData(writer, format);
                    } else {
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        this.binaryWritable.writeBinaryData(out, format);
                    }
                }
                catch (IOException ee) {
                    JOptionPane.showMessageDialog(this.stigmata, ee.getMessage(), Messages.getString("error.dialog.title"), 0);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ee2) {
                            throw new InternalError(ee2.getMessage());
                        }
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (UnsupportedFormatException ee) {
                    block25: {
                        JOptionPane.showMessageDialog(this.stigmata, ee.getMessage(), Messages.getString("error.dialog.title"), 0);
                        if (out == null) break block25;
                        try {
                            out.close();
                        }
                        catch (IOException ee3) {
                            throw new InternalError(ee3.getMessage());
                        }
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ee) {
                        throw new InternalError(ee.getMessage());
                    }
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }
}

