/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;

public class FileIOManager {
    private Component parent;
    private File currentDirectory;
    private BirthmarkEnvironment env;

    public FileIOManager(Component parent, BirthmarkEnvironment env) {
        this.parent = parent;
        this.env = env;
        if (env.getProperty(".current.directory") != null) {
            this.currentDirectory = new File(env.getProperty(".current.directory"));
        }
        if (env.getProperty("startup.directory") != null) {
            this.currentDirectory = new File(env.getProperty("startup.directory"));
        }
        if (this.currentDirectory == null && System.getProperty("execution.directory") != null) {
            this.currentDirectory = new File(System.getProperty("execution.directory"));
        }
        if (this.currentDirectory == null) {
            this.currentDirectory = new File(".");
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File directory) throws IllegalArgumentException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(directory.getName()) + " is not directory");
        }
        this.currentDirectory = directory;
        this.env.addProperty(".current.directory", directory.getAbsolutePath());
    }

    public File findFile(boolean open) {
        return this.findFile(open, new String[0], "");
    }

    public File[] openFiles(FileFilter[] filters, boolean multi, boolean directory) {
        JFileChooser chooser = new JFileChooser(this.getCurrentDirectory());
        if (filters != null) {
            int i = 0;
            while (i < filters.length) {
                chooser.addChoosableFileFilter(filters[i]);
                ++i;
            }
        }
        chooser.setMultiSelectionEnabled(multi);
        if (directory) {
            chooser.setFileSelectionMode(2);
        } else {
            chooser.setFileSelectionMode(0);
        }
        int returnValue = chooser.showOpenDialog(SwingUtilities.getRootPane(this.parent));
        if (returnValue == 0) {
            this.setCurrentDirectory(chooser.getCurrentDirectory());
            return chooser.getSelectedFiles();
        }
        return new File[0];
    }

    public File findFile(boolean open, String[] exts, String desc) {
        JFileChooser chooser = new JFileChooser(this.getCurrentDirectory());
        if (exts != null) {
            MessageFormat formatter = new MessageFormat(desc);
            int i = 0;
            while (i < exts.length) {
                chooser.addChoosableFileFilter(new ExtensionFilter(exts[i], formatter.format(new Object[]{exts[i]})));
                ++i;
            }
        }
        int returnValue = -1;
        returnValue = open ? chooser.showOpenDialog(SwingUtilities.getRootPane(this.parent)) : chooser.showSaveDialog(SwingUtilities.getRootPane(this.parent));
        if (returnValue == 0) {
            FileFilter filter;
            this.setCurrentDirectory(chooser.getCurrentDirectory());
            File file = chooser.getSelectedFile();
            if (!open && (filter = chooser.getFileFilter()) instanceof ExtensionFilter) {
                ExtensionFilter ef = (ExtensionFilter)filter;
                if (!filter.accept(file)) {
                    String[] extensions = ef.getExtensions();
                    file = this.setExtension(file, extensions[0]);
                }
            }
            return file;
        }
        return null;
    }

    private File setExtension(File file, String ext) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        String n = name;
        if (index > 0) {
            n = n.substring(0, index);
        }
        name = String.valueOf(n) + '.' + ext;
        return new File(file.getParentFile(), name);
    }
}

