/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ClippedLRListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 32943674625674235L;
    private final JLabel left = new JLabel();
    private final JLabel right = new JLabel();

    public ClippedLRListCellRenderer(Dimension dim, int rightWidth) {
        super(new BorderLayout());
        this.left.setOpaque(true);
        this.right.setOpaque(true);
        this.left.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.right.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.right.setPreferredSize(new Dimension(rightWidth, 0));
        this.add((Component)this.left, "Center");
        this.add((Component)this.right, "East");
        this.setPreferredSize(dim);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        LRItem item = (LRItem)value;
        if (item != null) {
            this.left.setText(String.valueOf(item.getLeft()));
            this.right.setText(String.valueOf(item.getRight()));
        }
        if (item.getIcon() != null) {
            this.left.setIcon(item.getIcon());
        }
        this.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
        this.left.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
        this.right.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
        this.left.setForeground(isSelected ? Color.white : Color.black);
        this.right.setForeground(isSelected ? Color.gray.brighter() : Color.gray);
        return this;
    }

    public static class LRItem {
        private Object left;
        private Object right;
        private Icon icon;

        public LRItem(Icon icon, Object left, Object right) {
            this(left, right);
            this.setIcon(icon);
        }

        public LRItem(Object left, Object right) {
            this.setLeft(left);
            this.setRight(right);
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Object getLeft() {
            return this.left;
        }

        public void setLeft(Object left) {
            this.left = left;
        }

        public Object getRight() {
            return this.right;
        }

        public void setRight(Object right) {
            this.right = right;
        }
    }
}

