/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.TargetSelectionPane;
import jp.naist.se.stigmata.ui.swing.Utility;

public class ClasspathSettingsPane
extends JPanel {
    private static final long serialVersionUID = 320973463423634L;
    private StigmataFrame stigmata;
    private TargetSelectionPane classpath;
    private TargetSelectionPane bootClasspath;

    public ClasspathSettingsPane(StigmataFrame frame) {
        this.stigmata = frame;
        this.initLayouts();
    }

    public void updateClasspathContext(ClasspathContext context) {
        String[] cplist = this.classpath.getValues();
        if (cplist != null && cplist.length >= 0) {
            int i = 0;
            while (i < cplist.length) {
                try {
                    URL url = null;
                    try {
                        url = new URL(cplist[i]);
                    }
                    catch (MalformedURLException e) {
                        url = new File(cplist[i]).toURI().toURL();
                    }
                    context.addClasspath(url);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void reset() {
        this.classpath.removeAllElements();
        this.bootClasspath.removeAllElements();
        try {
            ClasspathContext context = this.stigmata.getEnvironment().getClasspathContext();
            for (URL url : context) {
                this.classpath.addValue(url.toString());
            }
            this.addClasspath(this.bootClasspath, System.getProperty("java.class.path"));
            this.addClasspath(this.bootClasspath, System.getProperty("sun.boot.class.path"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private void addClasspath(TargetSelectionPane target, String classpath) {
        if (classpath != null) {
            target.addValues(classpath.split(System.getProperty("path.separator")));
            this.stigmata.setNeedToSaveSettings(true);
        }
    }

    private boolean findClass(String className) {
        try {
            String[] path;
            ClasspathContext b = Stigmata.getInstance().createEnvironment().getClasspathContext();
            ClasspathContext bytecode = new ClasspathContext(b);
            String[] stringArray = path = this.classpath.getValues();
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                String cp = stringArray[n2];
                bytecode.addClasspath(new File(cp).toURI().toURL());
                ++n2;
            }
            return bytecode.findClass(className) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    private void initLayouts() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        this.classpath = new TargetSelectionPane(this.stigmata);
        this.bootClasspath = new TargetSelectionPane(this.stigmata);
        Box south = Box.createHorizontalBox();
        final JButton findButton = Utility.createButton("findclass");
        final JTextField text = new JTextField();
        final JLabel label = new JLabel();
        this.classpath.setBorder(new TitledBorder(Messages.getString("userclasspath.border")));
        this.classpath.addTargetExtensions(Messages.getStringArray("userclasspath.extensions"));
        this.classpath.setDescription(Messages.getString("userclasspath.description"));
        this.classpath.setDirectorySelectable(true);
        this.bootClasspath.setBorder(new TitledBorder(Messages.getString("bootclasspath.border")));
        this.bootClasspath.setEnabled(false);
        findButton.setEnabled(false);
        south.setBorder(new TitledBorder(Messages.getString("classpathchecker.border")));
        label.setIcon(Utility.getIcon("classpathchecker.default.icon"));
        label.setToolTipText(Messages.getString("classpathchecker.default.tooltip"));
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.add((Component)south, "South");
        panel.add(this.classpath);
        panel.add(this.bootClasspath);
        south.add(Box.createHorizontalGlue());
        south.add(text);
        south.add(Box.createHorizontalGlue());
        south.add(findButton);
        south.add(Box.createHorizontalGlue());
        south.add(label);
        south.add(Box.createHorizontalGlue());
        text.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                String t = text.getText();
                findButton.setEnabled(t.trim().length() > 0);
            }

            public void insertUpdate(DocumentEvent arg0) {
                String t = text.getText();
                findButton.setEnabled(t.trim().length() > 0);
            }

            public void removeUpdate(DocumentEvent arg0) {
                String t = text.getText();
                findButton.setEnabled(t.trim().length() > 0);
            }
        });
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String t = text.getText().trim();
                boolean flag = ClasspathSettingsPane.this.findClass(t);
                String message = Messages.getString("classpathchecker.found.tooltip");
                if (flag) {
                    label.setIcon(Utility.getIcon("classpathchecker.found.icon"));
                } else {
                    label.setIcon(Utility.getIcon("classpathchecker.notfound.icon"));
                    message = Messages.getString("classpathchecker.notfound.tooltip");
                }
                label.setToolTipText(message);
                String dm = String.format("<html><body><dl><dt>%s</dt><dd>%s</dd></body></html>", t, message);
                JOptionPane.showMessageDialog(ClasspathSettingsPane.this.stigmata, dm, Messages.getString("classpathchecker.dialog.title"), 1);
            }
        };
        this.classpath.addDataChangeListener(new DataChangeListener(){

            public void valueChanged(Object source) {
                ClasspathSettingsPane.this.stigmata.setNeedToSaveSettings(true);
            }
        });
        findButton.addActionListener(action);
        text.addActionListener(action);
    }
}

