/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.result.AbstractExtractionResultSet;
import jp.naist.se.stigmata.utils.MultipleIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryExtractionResultSet
extends AbstractExtractionResultSet {
    private List<BirthmarkSet> targetX = new ArrayList<BirthmarkSet>();
    private List<BirthmarkSet> targetY = new ArrayList<BirthmarkSet>();

    public MemoryExtractionResultSet(BirthmarkContext context) {
        this(context, true);
    }

    public MemoryExtractionResultSet(BirthmarkContext context, boolean tableType) {
        super(context, tableType);
    }

    @Override
    public BirthmarkStoreTarget getStoreTarget() {
        return BirthmarkStoreTarget.MEMORY;
    }

    @Override
    public void removeAllBirthmarkSets(ExtractionTarget target) {
        switch (target) {
            case TARGET_X: 
            case TARGET_XY: {
                this.targetX.clear();
                break;
            }
            case TARGET_Y: {
                this.targetY.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown target: " + (Object)((Object)target));
            }
        }
    }

    @Override
    public void removeBirthmarkSet(ExtractionTarget target, BirthmarkSet set) {
        switch (target) {
            case TARGET_X: 
            case TARGET_XY: {
                this.targetX.remove(set);
                break;
            }
            case TARGET_Y: {
                this.targetY.remove(set);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown target: " + (Object)((Object)target));
            }
        }
    }

    @Override
    public void addBirthmarkSet(ExtractionTarget target, BirthmarkSet set) {
        switch (target) {
            case TARGET_X: 
            case TARGET_XY: {
                this.targetX.add(set);
                break;
            }
            case TARGET_Y: {
                this.targetY.add(set);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown target: " + (Object)((Object)target));
            }
        }
    }

    @Override
    public Iterator<BirthmarkSet> birthmarkSets(ExtractionTarget target) {
        Iterator<BirthmarkSet> iterator;
        switch (target) {
            case TARGET_X: 
            case TARGET_XY: {
                iterator = this.targetX.iterator();
                break;
            }
            case TARGET_Y: {
                iterator = this.targetY.iterator();
                break;
            }
            default: {
                MultipleIterator<BirthmarkSet> i = new MultipleIterator<BirthmarkSet>();
                i.add(this.targetX.iterator());
                i.add(this.targetY.iterator());
                iterator = i;
            }
        }
        return iterator;
    }

    @Override
    public int getBirthmarkSetSize(ExtractionTarget target) {
        int count = 0;
        switch (target) {
            case TARGET_X: 
            case TARGET_XY: {
                count = this.targetX.size();
                break;
            }
            case TARGET_Y: {
                count = this.targetY.size();
                break;
            }
            default: {
                count = this.targetX.size() + this.targetY.size();
            }
        }
        return count;
    }

    @Override
    public BirthmarkSet getBirthmarkSet(ExtractionTarget target, int index) {
        BirthmarkSet set;
        switch (target) {
            case TARGET_X: {
                set = this.targetX.get(index);
                break;
            }
            case TARGET_Y: {
                set = this.targetY.get(index);
                break;
            }
            default: {
                set = index < this.targetX.size() ? this.targetX.get(index) : this.targetY.get(index - this.targetX.size());
            }
        }
        return set;
    }

    @Override
    public BirthmarkSet[] getBirthmarkSets(ExtractionTarget target) {
        BirthmarkSet[] sets;
        switch (target) {
            case TARGET_X: 
            case TARGET_XY: {
                sets = this.targetX.toArray(new BirthmarkSet[this.targetX.size()]);
                break;
            }
            case TARGET_Y: {
                sets = this.targetY.toArray(new BirthmarkSet[this.targetX.size()]);
                break;
            }
            default: {
                sets = new BirthmarkSet[this.targetX.size() + this.targetY.size()];
                System.arraycopy(this.targetX.toArray(new BirthmarkSet[this.targetX.size()]), 0, sets, 0, this.targetX.size());
                System.arraycopy(this.targetY.toArray(new BirthmarkSet[this.targetY.size()]), 0, sets, this.targetX.size(), this.targetY.size());
            }
        }
        return sets;
    }
}

