/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.result.MemoryExtractionResultSet;
import jp.naist.se.stigmata.result.SingleExtractionResultSet;
import jp.naist.se.stigmata.result.XmlFileExtractionResultSet;

public class ExtractionResultSetFactory {
    private static ExtractionResultSetFactory instance = new ExtractionResultSetFactory();
    private Map<String, Class<? extends ExtractionResultSet>> map = new HashMap<String, Class<? extends ExtractionResultSet>>();

    private ExtractionResultSetFactory() {
        this.map.put(BirthmarkStoreTarget.MEMORY.name(), MemoryExtractionResultSet.class);
        this.map.put(BirthmarkStoreTarget.XMLFILE.name(), XmlFileExtractionResultSet.class);
        this.map.put(BirthmarkStoreTarget.MEMORY_SINGLE.name(), SingleExtractionResultSet.class);
    }

    public static ExtractionResultSetFactory getInstance() {
        return instance;
    }

    public ExtractionResultSet createResultSet(BirthmarkContext context) {
        return this.createResultSet(context.getStoreTarget(), context);
    }

    public ExtractionResultSet createResultSet(BirthmarkStoreTarget store, BirthmarkContext context) {
        try {
            Class<? extends ExtractionResultSet> clazz = this.map.get(store.name());
            Constructor<? extends ExtractionResultSet> constructor = clazz.getConstructor(BirthmarkContext.class);
            return constructor.newInstance(context);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }
}

