/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.result.AbstractComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtractionResultSet
implements ExtractionResultSet {
    private BirthmarkContext context;
    private boolean tableType = true;

    public AbstractExtractionResultSet(BirthmarkContext context) {
        this(context, true);
    }

    public AbstractExtractionResultSet(BirthmarkContext context, boolean tableType) {
        this.context = context;
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.context.getEnvironment();
    }

    @Override
    public BirthmarkContext getContext() {
        return this.context;
    }

    @Override
    public abstract void addBirthmarkSet(ExtractionTarget var1, BirthmarkSet var2) throws BirthmarkStoreException;

    @Override
    public abstract void removeBirthmarkSet(ExtractionTarget var1, BirthmarkSet var2);

    @Override
    public abstract void removeAllBirthmarkSets(ExtractionTarget var1);

    @Override
    public abstract int getBirthmarkSetSize(ExtractionTarget var1);

    @Override
    public abstract Iterator<BirthmarkSet> birthmarkSets(ExtractionTarget var1);

    @Override
    public int getBirthmarkSetSize() {
        return this.getBirthmarkSetSize(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public Iterator<BirthmarkSet> iterator() {
        return this.birthmarkSets(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public BirthmarkSet getBirthmarkSet(int index) {
        return this.getBirthmarkSet(ExtractionTarget.TARGET_BOTH, index);
    }

    @Override
    public BirthmarkSet getBirthmarkSet(String name) {
        return this.getBirthmarkSet(ExtractionTarget.TARGET_BOTH, name);
    }

    @Override
    public BirthmarkSet[] getBirthmarkSets() {
        return this.getBirthmarkSets(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public void removeBirthmarkSet(BirthmarkSet bs) {
        this.removeBirthmarkSet(ExtractionTarget.TARGET_BOTH, bs);
    }

    @Override
    public void removeAllBirthmarkSets() {
        this.removeAllBirthmarkSets(ExtractionTarget.TARGET_BOTH);
    }

    @Override
    public String[] getBirthmarkTypes() {
        return this.context.getBirthmarkTypes();
    }

    @Override
    public ExtractionUnit getExtractionUnit() {
        return this.context.getExtractionUnit();
    }

    @Override
    public BirthmarkSet getBirthmarkSet(ExtractionTarget target, int index) {
        int currentIndex = 0;
        Iterator<BirthmarkSet> i = this.birthmarkSets(target);
        while (i.hasNext()) {
            if (currentIndex == index) {
                return i.next();
            }
            i.next();
            ++currentIndex;
        }
        return null;
    }

    @Override
    public BirthmarkSet getBirthmarkSet(ExtractionTarget target, String setname) {
        Iterator<BirthmarkSet> i = this.birthmarkSets(target);
        while (i.hasNext()) {
            BirthmarkSet bs = i.next();
            if (!bs.getName().equals(setname)) continue;
            return bs;
        }
        return null;
    }

    @Override
    public synchronized BirthmarkSet[] getBirthmarkSets(ExtractionTarget target) {
        return AbstractComparisonResultSet.getArrays(this.birthmarkSets(target), new BirthmarkSet[0]);
    }

    @Override
    public void setBirthmarkSets(ExtractionTarget target, BirthmarkSet[] sets) throws BirthmarkStoreException {
        this.removeAllBirthmarkSets(target);
        int i = 0;
        while (i < sets.length) {
            this.addBirthmarkSet(target, sets[i]);
            ++i;
        }
    }

    @Override
    public boolean isTableType() {
        return this.tableType;
    }

    @Override
    public void setTableType(boolean flag) {
        this.tableType = flag;
    }

    protected String generateId() {
        SimpleDateFormat cdf = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        return cdf.format(Calendar.getInstance().getTime());
    }
}

