/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.reader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.utils.WarClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathContext
implements Iterable<URL> {
    private static ClasspathContext DEFAULT_CONTEXT = new ClasspathContext(false);
    private ClasspathContext parent;
    private List<URL> classpath = new ArrayList<URL>();
    private ClassLoader loader = null;

    private ClasspathContext(boolean flag) {
    }

    public ClasspathContext() {
        this(DEFAULT_CONTEXT);
    }

    public ClasspathContext(ClasspathContext parent) {
        this.parent = parent;
    }

    public ClasspathContext getParent() {
        return this.parent;
    }

    public static final ClasspathContext getDefaultContext() {
        return DEFAULT_CONTEXT;
    }

    public synchronized void addClasspath(URL url) {
        if (!this.contains(url)) {
            this.classpath.add(url);
            this.loader = null;
        }
    }

    public synchronized boolean contains(URL url) {
        return this.parent != null && this.parent.contains(url) || this.classpath.contains(url);
    }

    public int getClasspathSize() {
        int count = this.classpath.size();
        if (this.parent != null) {
            count += this.parent.getClasspathSize();
        }
        return count;
    }

    public synchronized URL[] getClasspathList() {
        ArrayList<URL> list = new ArrayList<URL>();
        for (URL url : this) {
            list.add(url);
        }
        return list.toArray(new URL[list.size()]);
    }

    public void clear() {
        this.classpath.clear();
    }

    public void clearAll() {
        this.clear();
        if (this.parent != null) {
            this.parent.clearAll();
        }
    }

    @Override
    public Iterator<URL> iterator() {
        if (this.parent == null) {
            return this.classpath.iterator();
        }
        final Iterator<URL> parentIterator = this.parent.iterator();
        final Iterator<URL> thisIterator = this.classpath.iterator();
        return new Iterator<URL>(){

            @Override
            public boolean hasNext() {
                boolean next = parentIterator.hasNext();
                if (!next) {
                    next = thisIterator.hasNext();
                }
                return next;
            }

            @Override
            public URL next() {
                URL nextObject = null;
                nextObject = parentIterator.hasNext() ? (URL)parentIterator.next() : (URL)thisIterator.next();
                return nextObject;
            }

            @Override
            public void remove() {
            }
        };
    }

    public synchronized ClassLoader createClassLoader() {
        if (this.loader == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            for (URL url : this) {
                list.add(url);
            }
            this.loader = new WarClassLoader(list.toArray(new URL[list.size()]), this.getClass().getClassLoader());
        }
        return this.loader;
    }

    public ClassFileEntry find(String className) throws ClassNotFoundException {
        ClassLoader loader = this.createClassLoader();
        URL resource = loader.getResource(String.valueOf(className.replace('.', '/')) + ".class");
        if (resource != null) {
            return new ClassFileEntry(className, resource);
        }
        return null;
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            ClassLoader loader = this.createClassLoader();
            return loader.loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
    }
}

