/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.filter;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.filter.Criterion;
import jp.naist.se.stigmata.filter.FilterTarget;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import org.apache.commons.beanutils.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonPairFilterManager {
    private Map<String, ComparisonPairFilterSpi> services = new HashMap<String, ComparisonPairFilterSpi>();
    private Map<String, ComparisonPairFilterSet> filters = new HashMap<String, ComparisonPairFilterSet>();
    private ComparisonPairFilterManager parent;

    public ComparisonPairFilterManager(BirthmarkEnvironment env, ComparisonPairFilterManager parent) {
        this.parent = parent;
        Iterator<ComparisonPairFilterSpi> i = env.lookupProviders(ComparisonPairFilterSpi.class);
        while (i.hasNext()) {
            ComparisonPairFilterSpi service = i.next();
            if (this.getService(service.getFilterName()) == null) continue;
            this.services.put(service.getFilterName(), service);
        }
    }

    public ComparisonPairFilterManager(BirthmarkEnvironment env) {
        Iterator<ComparisonPairFilterSpi> i = env.lookupProviders(ComparisonPairFilterSpi.class);
        while (i.hasNext()) {
            ComparisonPairFilterSpi service = i.next();
            this.services.put(service.getFilterName(), service);
        }
    }

    public synchronized ComparisonPairFilterSet[] getFilterSets() {
        ArrayList<ComparisonPairFilterSet> list = new ArrayList<ComparisonPairFilterSet>();
        if (this.parent != null) {
            ComparisonPairFilterSet[] comparisonPairFilterSetArray = this.parent.getFilterSets();
            int n = comparisonPairFilterSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                ComparisonPairFilterSet fs = comparisonPairFilterSetArray[n2];
                if (this.filters.get(fs.getName()) == null) {
                    list.add(fs);
                }
                ++n2;
            }
        }
        list.addAll(this.filters.values());
        return list.toArray(new ComparisonPairFilterSet[list.size()]);
    }

    public synchronized ComparisonPairFilterSet[] getFilterSets(String[] names) {
        ArrayList<ComparisonPairFilterSet> list = new ArrayList<ComparisonPairFilterSet>();
        int i = 0;
        while (i < names.length) {
            list.add(this.getFilterSet(names[i]));
            ++i;
        }
        return list.toArray(new ComparisonPairFilterSet[list.size()]);
    }

    public void addFilterSet(ComparisonPairFilterSet filterset) {
        this.filters.put(filterset.getName(), filterset);
    }

    public void removeFilterSet(String filterSetName) {
        if (this.filters.get(filterSetName) != null) {
            this.filters.remove(filterSetName);
        } else if (this.parent != null && this.parent.getFilterSet(filterSetName) != null) {
            this.filters.remove(filterSetName);
        }
    }

    public ComparisonPairFilterSet getFilterSet(String filterSetName) {
        ComparisonPairFilterSet filter = this.filters.get(filterSetName);
        if (filter == null && this.parent != null) {
            filter = this.parent.getFilterSet(filterSetName);
        }
        return filter;
    }

    public ComparisonPairFilter buildFilter(String filterName, String criterion, Map<String, String> values) {
        Criterion c = Criterion.valueOf(criterion);
        if (c != null) {
            return this.buildFilter(filterName, c, values);
        }
        throw new IllegalArgumentException("criterion not found: " + criterion);
    }

    public ComparisonPairFilter buildFilter(String filterName, Criterion criterion, Map<String, String> values) {
        ComparisonPairFilter filter = this.createFilter(filterName);
        if (filter != null) {
            filter.setCriterion(criterion);
            for (Map.Entry<String, String> entry : values.entrySet()) {
                try {
                    Object value = entry.getValue();
                    if (entry.getKey().equals("target")) {
                        value = FilterTarget.valueOf(String.valueOf(value));
                    }
                    BeanUtils.setProperty((Object)filter, (String)entry.getKey(), (Object)value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    filter = null;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    filter = null;
                }
            }
        }
        return filter;
    }

    public ComparisonPairFilter createFilter(String filterName) {
        if (this.hasService(filterName)) {
            return this.getService(filterName).getFilter();
        }
        return null;
    }

    public ComparisonPairFilterSpi removeService(String name) {
        if (this.parent != null && this.parent.hasService(name)) {
            this.parent.removeService(name);
        }
        return this.services.remove(name);
    }

    public void addService(ComparisonPairFilterSpi service) {
        if (this.parent == null || this.parent.getService(service.getFilterName()) == null) {
            this.services.put(service.getFilterName(), service);
        }
    }

    public boolean hasService(String name) {
        return this.parent != null && this.parent.hasService(name) || this.services.get(name) != null;
    }

    public ComparisonPairFilterSpi getService(String name) {
        ComparisonPairFilterSpi service = null;
        if (this.parent != null) {
            service = this.parent.getService(name);
        }
        if (service == null) {
            service = this.services.get(name);
        }
        return service;
    }
}

