/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.kgram;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KGram<T>
implements Serializable {
    private static final long serialVersionUID = 273465874532523L;
    private int maxLength = 4;
    private T[] values;

    public KGram(int kvalue) {
        this.setKValue(kvalue);
    }

    public void setKValue(int kvalue) {
        this.maxLength = kvalue;
    }

    public int getKValue() {
        return this.maxLength;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{ ");
        int i = 0;
        while (i < this.maxLength) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.get(i));
            ++i;
        }
        buffer.append(" }");
        return new String(buffer);
    }

    public void set(int index, T value) {
        if (index < 0 || index >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("expected 0-" + (this.maxLength - 1) + ": " + index);
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (this.values == null) {
            this.values = (Object[])Array.newInstance(value.getClass(), this.getKValue());
        }
        this.values[index] = value;
    }

    public T get(int index) {
        T returnValue = null;
        if (index < 0 || index >= this.maxLength) {
            throw new ArrayIndexOutOfBoundsException("expected 0-" + (this.maxLength - 1) + ": " + index);
        }
        if (this.values != null) {
            returnValue = this.values[index];
        }
        return returnValue;
    }

    public T[] toArray() {
        if (this.values == null) {
            throw new IllegalStateException("this object has no elements.");
        }
        Object[] newarray = (Object[])Array.newInstance(this.values[0].getClass(), this.getKValue());
        System.arraycopy(this.values, 0, newarray, 0, this.getKValue());
        return newarray;
    }

    public boolean equals(Object o) {
        if (o instanceof KGram) {
            KGram kgram = (KGram)o;
            boolean flag = this.getKValue() == kgram.getKValue();
            int i = 0;
            while (!flag && i < this.maxLength) {
                if (!this.get(i).equals(kgram.get(i))) {
                    flag = false;
                }
                ++i;
            }
            return flag;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public static <T> KGram<T>[] buildKGram(T[] values, int kvalue) {
        LinkedHashSet<KGram<T>> kgrams = new LinkedHashSet<KGram<T>>();
        if (values.length >= kvalue) {
            int max = values.length - (kvalue - 1);
            int i = 0;
            while (i < max) {
                KGram<T> kgram = new KGram<T>(kvalue);
                int j = 0;
                while (j < kvalue) {
                    kgram.set(j, values[i + j]);
                    ++j;
                }
                kgrams.add(kgram);
                ++i;
            }
        }
        return kgrams.toArray(new KGram[kgrams.size()]);
    }
}

