/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEngine;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ComparisonMethod;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.event.BirthmarkEngineAdapter;
import jp.naist.se.stigmata.event.BirthmarkEngineEvent;
import jp.naist.se.stigmata.event.WarningMessages;
import jp.naist.se.stigmata.printer.BirthmarkServicePrinter;
import jp.naist.se.stigmata.printer.ComparisonResultSetPrinter;
import jp.naist.se.stigmata.printer.ExtractionResultSetPrinter;
import jp.naist.se.stigmata.printer.PrinterManager;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.spi.ResultPrinterSpi;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.utils.ConfigFileExporter;
import jp.sourceforge.talisman.xmlcli.CommandLinePlus;
import jp.sourceforge.talisman.xmlcli.OptionsBuilder;
import jp.sourceforge.talisman.xmlcli.builder.OptionsBuilderFactory;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public final class Main {
    private PrinterManager manager = PrinterManager.getInstance();

    public Main(String[] args) throws ParseException {
        Options options = this.buildOptions();
        PosixParser parser = new PosixParser();
        CommandLinePlus commandLine = new CommandLinePlus(parser.parse(options, args, false));
        Stigmata stigmata = Stigmata.getInstance();
        stigmata.configuration(commandLine.getOptionValue("config-file"), commandLine.hasOption("reset-config"));
        String[] arguments = commandLine.getArgs();
        String mode = commandLine.getOptionValue("mode");
        String format = commandLine.getOptionValue("format");
        if (format == null) {
            format = "xml";
        }
        if (mode == null) {
            mode = "gui";
        }
        BirthmarkContext context = stigmata.createContext();
        this.updateContext(context, commandLine);
        boolean exitFlag = this.executeOption(context.getEnvironment(), commandLine, options);
        if (!exitFlag) {
            if (!("gui".equals(mode) || "list".equals(mode) || arguments != null && arguments.length != 0)) {
                this.printHelp(context.getEnvironment(), options);
                return;
            }
            if (mode.equals("list")) {
                this.listBirthmarks(context, format);
            } else if (mode.equals("extract")) {
                this.extractBirthmarks(stigmata, arguments, format, context);
            } else if (mode.equals("compare")) {
                this.compareBirthmarks(stigmata, arguments, format, context);
            } else if (mode.equals("gui")) {
                StigmataFrame frame = new StigmataFrame(stigmata, context.getEnvironment());
                frame.setVisible(true);
            }
        }
    }

    private void extractBirthmarks(Stigmata stigmata, String[] args, String format, BirthmarkContext context) {
        try {
            context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_SAME_PAIR);
            BirthmarkEngine engine = new BirthmarkEngine(context.getEnvironment());
            engine.addBirthmarkEngineListener(new BirthmarkEngineAdapter(){

                public void operationDone(BirthmarkEngineEvent e) {
                    WarningMessages warnings = e.getMessage();
                    Iterator<Exception> i = warnings.exceptions();
                    while (i.hasNext()) {
                        i.next().printStackTrace();
                    }
                }
            });
            ExtractionResultSet ers = engine.extract(args, context);
            ResultPrinterSpi spi = this.manager.getService(format);
            ExtractionResultSetPrinter formatter = spi.getExtractionResultSetPrinter();
            formatter.printResult(new PrintWriter(System.out), ers);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void compareBirthmarks(Stigmata stigmata, String[] args, String format, BirthmarkContext context) {
        try {
            BirthmarkEngine engine = new BirthmarkEngine(context.getEnvironment());
            context.setComparisonMethod(ComparisonMethod.ROUND_ROBIN_SAME_PAIR);
            engine.addBirthmarkEngineListener(new BirthmarkEngineAdapter(){

                public void operationDone(BirthmarkEngineEvent e) {
                    WarningMessages warnings = e.getMessage();
                    Iterator<Exception> i = warnings.exceptions();
                    while (i.hasNext()) {
                        i.next().printStackTrace();
                    }
                }
            });
            ExtractionResultSet rs = engine.extract(args, context);
            ComparisonResultSet resultset = engine.compare(rs);
            if (context.hasFilter()) {
                resultset = engine.filter(resultset);
            }
            ResultPrinterSpi spi = this.manager.getService(format);
            ComparisonResultSetPrinter formatter = spi.getComparisonResultSetPrinter();
            formatter.printResult(new PrintWriter(System.out), resultset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listBirthmarks(BirthmarkContext context, String format) {
        try {
            BirthmarkSpi[] spis = context.getEnvironment().findServices();
            ResultPrinterSpi spi = this.manager.getService(format);
            BirthmarkServicePrinter formatter = spi.getBirthmarkServicePrinter();
            formatter.printResult(new PrintWriter(System.out), spis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateContext(BirthmarkContext context, CommandLinePlus cl) {
        BirthmarkEnvironment env = context.getEnvironment();
        String[] birthmarks = this.getTargetBirthmarks(env, cl);
        int i = 0;
        while (i < birthmarks.length) {
            context.addBirthmarkType(birthmarks[i]);
            ++i;
        }
        if (cl.hasOption("filter")) {
            String[] filters = cl.getOptionValues("filter");
            int i2 = 0;
            while (i2 < filters.length) {
                context.addFilterType(filters[i2]);
                ++i2;
            }
        }
        if (cl.hasOption("store-target")) {
            String value = cl.getOptionValue("store-target");
            BirthmarkStoreTarget bst = BirthmarkStoreTarget.valueOf(value);
            if (bst == null) {
                bst = BirthmarkStoreTarget.MEMORY;
            }
            context.setStoreTarget(bst);
        }
        if (cl.hasOption("extraction-unit")) {
            ExtractionUnit unit = ExtractionUnit.valueOf(cl.getOptionValue("extraction-unit"));
            context.setExtractionUnit(unit);
        }
        this.addClasspath(env.getClasspathContext(), cl);
    }

    private String[] getTargetBirthmarks(BirthmarkEnvironment env, CommandLinePlus cl) {
        String[] birthmarks = cl.getOptionValues("birthmark");
        if (birthmarks == null || birthmarks.length == 0) {
            ArrayList<String> birthmarkList = new ArrayList<String>();
            BirthmarkSpi[] birthmarkSpiArray = env.getServices();
            int n = birthmarkSpiArray.length;
            int n2 = 0;
            while (n2 < n) {
                BirthmarkSpi service = birthmarkSpiArray[n2];
                if (!service.isExpert()) {
                    birthmarkList.add(service.getType());
                }
                ++n2;
            }
            birthmarks = birthmarkList.toArray(new String[birthmarkList.size()]);
        }
        return birthmarks;
    }

    private void addClasspath(ClasspathContext context, CommandLinePlus commandLine) {
        String[] classpath = commandLine.getOptionValues("classpath");
        if (classpath != null) {
            String[] stringArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                String cp = stringArray[n2];
                try {
                    File f = new File(cp);
                    if (f.exists()) {
                        context.addClasspath(f.toURI().toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    private boolean executeOption(BirthmarkEnvironment env, CommandLinePlus commandLine, Options options) {
        boolean exitFlag = false;
        if (commandLine.hasOption("help")) {
            this.printHelp(env, options);
            exitFlag = true;
        }
        if (commandLine.hasOption("version")) {
            this.printVersion();
            exitFlag = true;
        }
        if (commandLine.hasOption("license")) {
            this.printLicense();
            exitFlag = true;
        }
        if (commandLine.hasOption("export-config")) {
            this.exportConfiguration(env, commandLine.getOptionValue("export-config"));
            exitFlag = true;
        }
        return exitFlag;
    }

    private Options buildOptions() {
        try {
            OptionsBuilderFactory factory = OptionsBuilderFactory.getInstance();
            URL location = this.getClass().getResource("/resources/options.xml");
            OptionsBuilder builder = factory.createBuilder(location);
            Options options = builder.buildOptions();
            return options;
        }
        catch (DOMException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void exportConfiguration(BirthmarkEnvironment env, String file) {
        try {
            PrintWriter out;
            if (file == null) {
                out = new PrintWriter(System.out);
            } else {
                if (!file.endsWith(".xml")) {
                    file = String.valueOf(file) + ".xml";
                }
                out = new PrintWriter(new FileWriter(file));
            }
            new ConfigFileExporter(env).export(out);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printHelp(BirthmarkEnvironment env, Options options) {
        Package p = this.getClass().getPackage();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(String.format("java -jar stigmata-%s.jar <OPTIONS> <TARGETS>%nTARGETS is allowed as jar files, war files, class files, and classpath directory.", p.getImplementationVersion()), options);
        System.out.println();
        System.out.println("Available birthmarks:");
        Object[] objectArray = env.getServices();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BirthmarkSpi service = objectArray[n2];
            if (!service.isExpert()) {
                System.out.printf("    %-5s (%s): %s%n", service.getType(), service.getDisplayType(), service.getDescription());
            }
            ++n2;
        }
        System.out.println();
        System.out.println("Available filers:");
        objectArray = env.getFilterManager().getFilterSets();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object filterset = objectArray[n2];
            System.out.printf("    %s (%s)%n", ((ComparisonPairFilterSet)filterset).getName(), ((ComparisonPairFilterSet)filterset).isMatchAll() ? "match all" : "match any");
            Iterator<ComparisonPairFilter> iterator = ((ComparisonPairFilterSet)filterset).iterator();
            while (iterator.hasNext()) {
                ComparisonPairFilter filter = iterator.next();
                System.out.printf("        %s%n", filter);
            }
            ++n2;
        }
        System.out.println();
        System.out.println("Copyright (C) by Haruaki Tamada, Ph.D.");
        System.out.println("Please notify us some bugs and requests to <stigmata-info[ at ]lists.sourceforge.jp>");
    }

    public void printLicense() {
        try {
            String line;
            InputStream in = this.getClass().getResourceAsStream("/META-INF/license.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void printVersion() {
        Package p = this.getClass().getPackage();
        System.out.println("stigmata version " + p.getImplementationVersion());
    }

    public static void main(String[] args) throws Exception {
        new Main(args);
    }
}

