/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sourceforge.talisman.xmlcli.builder.AbstractOptionsBuilder;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxOptionsBuilder
extends AbstractOptionsBuilder {
    private String optionTarget;

    public SaxOptionsBuilder(InputStream in) {
        super(in);
    }

    public String getDefinitionName() {
        return this.optionTarget;
    }

    public Options buildOptions() throws IOException, SAXException {
        Options options = new Options();
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            parser.parse(this.getStream(), (DefaultHandler)new OptionsBuilderHandler(options));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    public class OptionsBuilderHandler
    extends DefaultHandler {
        private Map<String, Option> map = new HashMap<String, Option>();
        private String tag;
        private String optionName = null;
        private boolean definitionPart = false;
        private boolean optionBuildPart = false;
        private Options options;
        private String opt;
        private String longopt;
        private String arg = "NONE";
        private String description;
        private String argname;
        private boolean require;
        private boolean multipleArg;
        private String valueSeparator;
        private String type;
        private OptionGroup group;
        private int argumentCount = -1;

        public OptionsBuilderHandler(Options options) {
            this.options = options;
        }

        public void startDocument() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) {
            this.tag = name;
            if (name.equals("definitions")) {
                this.definitionPart = true;
            } else if (name.equals("command-line")) {
                int index = attributes.getIndex("name");
                if (index != -1) {
                    SaxOptionsBuilder.this.optionTarget = attributes.getValue(index);
                }
            } else if (name.equals("definition")) {
                int index = attributes.getIndex("name");
                if (index != -1) {
                    this.optionName = attributes.getValue(index);
                }
            } else if (name.equals("available-options")) {
                this.optionBuildPart = true;
            } else if (name.equals("group")) {
                this.group = new OptionGroup();
            }
        }

        public void characters(char[] ch, int offset, int length) {
            String value = new String(ch, offset, length).trim();
            if (value.equals("")) {
                return;
            }
            if (this.definitionPart) {
                if (this.tag.equals("short-option")) {
                    this.opt = value;
                } else if (this.tag.equals("long-option")) {
                    this.longopt = value;
                } else if (this.tag.equals("argument")) {
                    this.arg = value;
                } else if (this.tag.equals("argument-name")) {
                    this.argname = value;
                } else if (this.tag.equals("require")) {
                    this.require = true;
                } else if (this.tag.equals("type")) {
                    this.type = value;
                } else if (this.tag.equals("value-separator")) {
                    this.valueSeparator = value;
                } else if (this.tag.equals("multiple-args")) {
                    if (value.trim().length() > 0) {
                        this.argumentCount = Integer.parseInt(value);
                    }
                    this.multipleArg = true;
                } else if (this.tag.equals("description")) {
                    if (this.description == null) {
                        this.description = "";
                    }
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new StringReader(value));
                        StringBuffer sb = new StringBuffer(this.description);
                        while ((line = reader.readLine()) != null) {
                            sb.append(line).append(" ");
                        }
                        this.description = new String(sb);
                    }
                    catch (IOException e) {}
                }
            } else if (this.optionBuildPart) {
                if (this.tag.equals("option")) {
                    Option o = this.map.get(value);
                    if (o != null) {
                        if (this.group != null) {
                            this.group.addOption(o);
                        } else {
                            this.options.addOption(o);
                        }
                    }
                } else if (this.tag.equals("group")) {
                    this.group = new OptionGroup();
                }
            }
        }

        public void endElement(String uri, String localName, String name) {
            if (name.equals("definitions")) {
                this.definitionPart = false;
            } else if (name.equals("available-options")) {
                this.optionBuildPart = false;
            } else if (name.equals("definition")) {
                Option option = this.createOption();
                this.map.put(this.optionName, option);
                this.optionName = null;
                this.opt = null;
                this.longopt = null;
                this.arg = "NONE";
                this.description = null;
                this.argname = null;
                this.argumentCount = -1;
                this.require = false;
                this.multipleArg = false;
                this.valueSeparator = null;
            } else if (this.optionBuildPart && name.equals("group")) {
                this.options.addOptionGroup(this.group);
                this.group = null;
            }
        }

        public void endDocument() {
        }

        private Option createOption() {
            boolean hasArg = false;
            if (!this.arg.equals("NONE")) {
                hasArg = true;
            }
            this.description.trim();
            OptionBuilder builder = null;
            if (this.longopt != null) {
                builder = OptionBuilder.withLongOpt(this.longopt);
            }
            if (hasArg) {
                builder = OptionBuilder.hasArg(hasArg);
            }
            if (this.argname != null) {
                builder = OptionBuilder.withArgName(this.argname);
            }
            if (this.description != null) {
                builder = OptionBuilder.withDescription(this.description);
            }
            if (this.valueSeparator != null) {
                builder = OptionBuilder.withValueSeparator(this.valueSeparator.charAt(0));
            }
            if (this.type != null) {
                builder = OptionBuilder.withType(this.type);
            }
            if (this.arg.equals("OPTIONAL")) {
                builder = builder.hasOptionalArg();
            }
            if (this.multipleArg) {
                builder = this.arg.equals("OPTIONAL") ? (this.argumentCount > 0 ? OptionBuilder.hasOptionalArgs(this.argumentCount) : builder.hasOptionalArgs()) : (this.argumentCount > 0 ? OptionBuilder.hasArgs(this.argumentCount) : builder.hasArgs());
            }
            if (this.require) {
                builder = builder.isRequired();
            }
            Option option = this.opt != null ? OptionBuilder.create(this.opt) : builder.create();
            return option;
        }
    }
}

