package jp.naist.se.stigmata.ui.swing.mds;

/*
 * $Id: MDSPointsLocationExporter.java 169 2007-07-16 01:48:27Z tama3 $
 */

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.UnsupportedFormatException;
import jp.naist.se.stigmata.utils.AsciiDataWritable;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 169 $ $Date: 2007-07-16 10:48:27 +0900 (Mon, 16 Jul 2007) $
 */
public class MDSPointsLocationExporter implements AsciiDataWritable{
    private MDSGraphViewer viewer;

    public MDSPointsLocationExporter(MDSGraphViewer viewer){
        this.viewer = viewer;
    }

    public void writeAsciiData(PrintWriter out, String format)
            throws IOException, UnsupportedFormatException{
        if(!format.equals("csv")){
            throw new UnsupportedFormatException(Messages.getString("error.unsupportedformat", format));
        }
        for(Iterator<Coordinate> i = viewer.coordinates(); i.hasNext(); ){
            Coordinate c = i.next();
            out.printf("%s,%s,%g,%g%n", c.getLabel(), c.getGroupId(), c.getX(), c.getY());
        }
    }

}
