package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkComparator.java 173 2007-07-16 02:24:32Z tama3 $
 */

/**
 * Interface for comparing given two birthmarks and calculate similarity.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 173 $ $Date: 2007-07-16 11:24:32 +0900 (Mon, 16 Jul 2007) $
 */
public interface BirthmarkComparator {
    /**
     * compare given two birthmarks and returns calculated similarity. 
     */
    public double compare(Birthmark b1, Birthmark b2);

    /**
     * returns the number of comparison. 
     */
    public int getCompareCount(Birthmark b1, Birthmark b2);

    /**
     * returns the type of birthmarks this comparator supports. 
     */
    public String getType();
}
