/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.birthmarks.BirthmarkService;
import jp.naist.se.stigmata.utils.WellknownClassJudgeRule;
import jp.naist.se.stigmata.utils.WellknownClassManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFileImporter {
    private BirthmarkEnvironment environment;

    public ConfigFileImporter(BirthmarkEnvironment environment) {
        this.environment = environment;
    }

    public ConfigFileImporter() {
    }

    public BirthmarkEnvironment parse(InputStream in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler(this.getEnvironment());
            parser.parse(in, (DefaultHandler)handler);
            this.environment = handler.getEnvironment();
            return this.environment;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public BirthmarkEnvironment getEnvironment() {
        return this.environment;
    }

    private static class Handler
    extends DefaultHandler {
        private BirthmarkEnvironment environment;
        private WellknownClassManager manager;
        private BirthmarkService service;
        private ComparisonPairFilterSet filter;
        private Part part;
        private int wellknownType = 0;
        private int patternType = 0;
        private String qname;
        private String key;
        private String filterType;
        private String filterCriterion;
        private String attributeName;
        private Map<String, String> filterAttributes = new HashMap<String, String>();

        public Handler(BirthmarkEnvironment environment) {
            if (environment == null) {
                environment = new BirthmarkEnvironment();
            }
            this.environment = environment;
            this.manager = environment.getWellknownClassManager();
        }

        public BirthmarkEnvironment getEnvironment() {
            return this.environment;
        }

        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            this.qname = qname;
            if (qname.equals("wellknown-classes")) {
                this.part = Part.WELLKNOWN_CLASSES;
            } else if (qname.equals("property")) {
                this.part = Part.PROPERTIES;
            } else if (qname.equals("classpath-list")) {
                this.part = Part.CLASSPATH;
            } else if (qname.equals("birthmark-service")) {
                this.part = Part.SERVICES;
                this.service = new BirthmarkService();
                this.service.setUserDefined(false);
            } else if (qname.equals("filterset-list")) {
                this.part = Part.FILTER_SET;
            }
            if (this.part == Part.FILTER_SET) {
                if (qname.equals("filterset")) {
                    this.filter = new ComparisonPairFilterSet();
                } else if (qname.equals("filter")) {
                    this.part = Part.FILTER_DEFINITION;
                    this.filterAttributes.clear();
                }
            } else if (this.part == Part.WELLKNOWN_CLASSES) {
                if (qname.equals("exclude")) {
                    this.wellknownType = 128;
                } else if (qname.equals("package")) {
                    this.wellknownType = 32;
                } else if (qname.equals("class-name")) {
                    this.wellknownType = 64;
                } else if (qname.equals("fully-name")) {
                    this.wellknownType = 16;
                } else if (qname.equals("suffix")) {
                    this.patternType = 2;
                } else if (qname.equals("prefix")) {
                    this.patternType = 1;
                } else if (qname.equals("match")) {
                    this.patternType = 4;
                }
            }
        }

        public void characters(char[] data, int offset, int length) throws SAXException {
            String value = new String(data, offset, length).trim();
            if (value.length() > 0) {
                if (this.part == Part.PROPERTIES) {
                    if (this.qname.equals("name")) {
                        this.key = value;
                    } else if (this.qname.equals("value")) {
                        this.environment.addProperty(this.key, value);
                    }
                } else if (this.part == Part.WELLKNOWN_CLASSES && (this.qname.equals("suffix") || this.qname.equals("prefix") || this.qname.equals("match"))) {
                    this.manager.add(new WellknownClassJudgeRule(value, this.wellknownType | this.patternType));
                } else if (this.part == Part.CLASSPATH && this.qname.equals("classpath")) {
                    try {
                        this.environment.getClasspathContext().addClasspath(new URL(value));
                    }
                    catch (MalformedURLException e) {
                        throw new SAXException(e);
                    }
                } else if (this.part == Part.SERVICES) {
                    if (this.qname.equals("type")) {
                        this.service.setType(value);
                    } else if (this.qname.equals("display-name")) {
                        this.service.setDisplayType(value);
                    } else if (this.qname.equals("description")) {
                        this.service.setDescription(value);
                    } else if (this.qname.equals("extractor")) {
                        this.service.setExtractorClassName(value);
                    } else if (this.qname.equals("comparator")) {
                        this.service.setComparatorClassName(value);
                    }
                } else if (this.part == Part.FILTER_SET) {
                    if (this.qname.equals("name")) {
                        this.filter.setName(value);
                    } else if (this.qname.equals("match")) {
                        if (value.equals("all")) {
                            this.filter.setMatchAll();
                        } else {
                            this.filter.setMatchAny();
                        }
                    }
                } else if (this.part == Part.FILTER_DEFINITION) {
                    if (this.qname.equals("filter-type")) {
                        this.filterType = value;
                    } else if (this.qname.equals("criterion")) {
                        this.filterCriterion = value;
                    } else if (this.qname.equals("name")) {
                        this.attributeName = value;
                    } else {
                        this.filterAttributes.put(this.attributeName, value);
                    }
                }
            }
        }

        public void endElement(String uri, String localname, String qname) {
            if (this.part == Part.SERVICES && qname.equals("birthmark-service")) {
                this.environment.addService(this.service);
                this.service = null;
            } else if (this.part == Part.FILTER_DEFINITION && qname.equals("filter")) {
                ComparisonPairFilter f = this.environment.getFilterManager().buildFilter(this.filterType, this.filterCriterion, this.filterAttributes);
                this.filter.addFilter(f);
                this.part = Part.FILTER_SET;
            } else if (this.part == Part.FILTER_SET && qname.equals("filterset")) {
                this.environment.getFilterManager().addFilterSet(this.filter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Part {
        WELLKNOWN_CLASSES,
        PROPERTIES,
        CLASSPATH,
        SERVICES,
        FILTER_SET,
        FILTER_DEFINITION;

    }
}

