/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.naist.se.stigmata.ui.swing.mds.GeometoryType;

class LabelMap {
    private List<String> labels = new ArrayList<String>();
    private Map<String, String> groups = new HashMap<String, String>();
    private Map<String, Integer> gids = new HashMap<String, Integer>();
    private boolean groupEnabled = true;

    public LabelMap() {
        this.gids.put("", 0);
    }

    public LabelMap(String[] labels) {
        this();
        for (String label : labels) {
            this.addLabel(label);
        }
    }

    public boolean isAvailableLabel(int index) {
        return index >= 0 && index < this.labels.size();
    }

    public void setGroupEnabled(boolean flag) {
        this.groupEnabled = flag;
    }

    public boolean isGroupEnabled() {
        return this.groupEnabled && this.getGroupCount() < GeometoryType.getMaxGroupCount();
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public String getLabel(int index) {
        return this.labels.get(index);
    }

    public void setGroup(String label, String groupLabel) {
        this.groups.put(label, groupLabel);
        if (this.gids.get(groupLabel) == null) {
            this.gids.put(groupLabel, this.gids.size());
        }
    }

    public String getGroup(String label) {
        String group = this.groups.get(label);
        if (group == null) {
            group = "";
        }
        return group;
    }

    public int getGroupIdFromElementName(String label) {
        return this.getGroupId(this.groups.get(label));
    }

    public int getGroupId(String groupLabel) {
        Integer i = new Integer(0);
        if (this.isGroupEnabled() && (i = this.gids.get(groupLabel)) == null) {
            i = new Integer(0);
        }
        return i;
    }

    public int getGroupCount() {
        return this.gids.size();
    }

    public String[] getGroupNames() {
        String[] names = new String[this.gids.size()];
        int index = 0;
        Iterator<String> i$ = this.gids.keySet().iterator();
        while (i$.hasNext()) {
            String name;
            names[index] = name = i$.next();
            ++index;
        }
        return names;
    }

    public synchronized int getGroupElementCount(String group) {
        int count = 0;
        for (Map.Entry<String, String> entry : this.groups.entrySet()) {
            if (!group.equals(entry.getValue())) continue;
            ++count;
        }
        return count;
    }

    public synchronized String[] getGroupElements(String group) {
        ArrayList<String> elements = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.groups.entrySet()) {
            if (!group.equals(entry.getValue())) continue;
            elements.add(entry.getKey());
        }
        return elements.toArray(new String[elements.size()]);
    }
}

