/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class PropertyEditPane
extends JPanel {
    private static final long serialVersionUID = 12397342543653L;
    private StigmataFrame stigmata;
    private JTable table;
    private DefaultTableModel model;

    public PropertyEditPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initData();
    }

    public void updateEnvironment(BirthmarkEnvironment environment) {
        environment.clearProperties();
        int i = 0;
        while (i < this.model.getRowCount()) {
            environment.addProperty((String)this.model.getValueAt(i, 0), (String)this.model.getValueAt(i, 1));
            ++i;
        }
    }

    private void initData() {
        BirthmarkEnvironment environment = this.stigmata.getEnvironment();
        environment.addPropertyListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                String value = (String)evt.getNewValue();
                if (value == null) {
                    PropertyEditPane.this.removeProperty(name);
                } else {
                    PropertyEditPane.this.addOrUpdateProperty(name, value);
                }
            }
        });
        Iterator<String> i = environment.propertyKeys();
        while (i.hasNext()) {
            String key = i.next();
            this.model.addRow(new Object[]{key, environment.getProperty(key)});
        }
    }

    private void removeProperty(String name) {
        int index = this.findIndex(name);
        if (index >= 0) {
            this.model.removeRow(index);
        }
    }

    private void addOrUpdateProperty(String name, String value) {
        int index = this.findIndex(name);
        if (index >= 0) {
            this.model.setValueAt(value, index, 1);
        } else {
            this.model.addRow(new Object[]{name, value});
        }
    }

    private int findIndex(String name) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            String v = (String)this.model.getValueAt(i, 0);
            if (v.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addNewProperty() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel nameLabel = new JLabel(Messages.getString("propertyname.label"));
        JLabel valueLabel = new JLabel(Messages.getString("propertyvalue.label"));
        JTextField name = new JTextField(15);
        JTextField value = new JTextField(15);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        layout.setConstraints(nameLabel, gbc);
        panel.add(nameLabel);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.fill = 2;
        layout.setConstraints(name, gbc);
        panel.add(name);
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        layout.setConstraints(valueLabel, gbc);
        panel.add(valueLabel);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        layout.setConstraints(value, gbc);
        panel.add(value);
        int val = JOptionPane.showConfirmDialog(this.stigmata, panel, Messages.getString("propertyadd.dialog.title"), 0, 3);
        if (val == 0) {
            this.model.addRow(new Object[]{name.getText().trim(), value.getText()});
        }
    }

    private void removeSelectedProperty() {
        int[] indexes = this.table.getSelectedRows();
        int i = indexes.length - 1;
        while (i >= 0) {
            this.model.removeRow(indexes[i]);
            --i;
        }
    }

    private void initLayouts() {
        this.model = new DefaultTableModel();
        this.model.addColumn(Messages.getString("propertyname.label"));
        this.model.addColumn(Messages.getString("propertyvalue.label"));
        this.table = new JTable(this.model);
        this.table.setSelectionMode(2);
        this.table.setColumnSelectionAllowed(false);
        JButton add = Utility.createButton("propertyadd");
        final JButton remove = Utility.createButton("propertyremove");
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.table);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(add);
        box.add(Box.createHorizontalGlue());
        box.add(remove);
        box.add(Box.createHorizontalGlue());
        this.add((Component)scroll, "Center");
        this.add((Component)box, "South");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditPane.this.addNewProperty();
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditPane.this.removeSelectedProperty();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                remove.setEnabled(PropertyEditPane.this.table.getSelectedRowCount() != 0);
            }
        });
        remove.setEnabled(false);
    }
}

