/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkSet;

public class ClassNameObfuscator {
    private Map<String, String> nameMapping = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputNameMappings(File file) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            for (String oldName : this.nameMapping.keySet()) {
                String newName = this.nameMapping.get(oldName);
                out.print(oldName);
                out.print(",");
                out.println(newName);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public BirthmarkSet obfuscateClassName(BirthmarkSet orig) {
        String newName = this.nameMapping.get(orig.getName());
        if (newName == null) {
            newName = String.format("C%04d", new Integer(this.nameMapping.size() + 1));
            this.nameMapping.put(orig.getName(), newName);
        }
        BirthmarkSet newSet = new BirthmarkSet(newName, orig.getLocation());
        for (Birthmark birthmark : orig) {
            newSet.addBirthmark(birthmark);
        }
        return newSet;
    }
}

