/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.reader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import jp.naist.se.stigmata.reader.ClassFileEntry;
import jp.naist.se.stigmata.reader.JarClassFileArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarClassFileArchive
extends JarClassFileArchive {
    public WarClassFileArchive(String jarfile) throws IOException {
        super(jarfile);
    }

    @Override
    public InputStream getInputStream(ClassFileEntry entry) throws IOException {
        if (this.hasEntry(entry.getClassName())) {
            return entry.getLocation().openStream();
        }
        return null;
    }

    @Override
    public Iterator<ClassFileEntry> iterator() {
        ArrayList<ClassFileEntry> list = new ArrayList<ClassFileEntry>();
        Enumeration<JarEntry> e = this.jarentries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            URL location = null;
            try {
                location = new URL("jar:" + this.getLocation() + "!/WEB-INF/classes/" + entry.getName());
                String className = entry.getName();
                className = className.substring("WEB-INF/classes/".length(), className.length() - ".class".length());
                className = className.replace('/', '.');
                list.add(new ClassFileEntry(className, location));
            }
            catch (MalformedURLException ex) {}
        }
        return list.iterator();
    }

    @Override
    public boolean hasEntry(String className) {
        return this.hasJarEntry("WEB-INF/classes/" + className.replace('.', '/') + ".class");
    }

    @Override
    public ClassFileEntry getEntry(String className) throws ClassNotFoundException {
        if (this.hasEntry(className)) {
            String entryName = className.replace('.', '/') + ".class";
            try {
                URL location = new URL("jar:" + this.getLocation() + "!/WEB-INF/classes/" + entryName);
                return new ClassFileEntry(className, location);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }
}

