/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertainPairComparisonResultSet
implements ComparisonResultSet {
    private BirthmarkEnvironment environment;
    private List<ComparisonPair> pairList = new ArrayList<ComparisonPair>();
    private Map<URL, BirthmarkSet> sources = new HashMap<URL, BirthmarkSet>();

    public CertainPairComparisonResultSet(ComparisonPair[] pairs, BirthmarkEnvironment environment) {
        this.environment = environment;
        for (int i = 0; i < pairs.length; ++i) {
            this.pairList.add(pairs[i]);
            this.sources.put(pairs[i].getTarget1().getLocation(), pairs[i].getTarget1());
            this.sources.put(pairs[i].getTarget2().getLocation(), pairs[i].getTarget2());
        }
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, BirthmarkEnvironment environment) {
        this.environment = environment;
        for (int i = 0; i < targetX.length; ++i) {
            BirthmarkSet target2 = this.findTarget(targetX[i].getName(), targetY);
            if (target2 == null) continue;
            this.pairList.add(new ComparisonPair(targetX[i], target2, environment));
        }
        this.addSources(targetX);
        this.addSources(targetY);
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, Map<String, String> mapping, BirthmarkEnvironment environment) {
        this.environment = environment;
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            BirthmarkSet target1 = this.findTarget(entry.getKey(), targetX);
            BirthmarkSet target2 = this.findTarget(entry.getValue(), targetY);
            if (target1 == null && target2 == null) {
                target1 = this.findTarget(entry.getKey(), targetY);
                target2 = this.findTarget(entry.getValue(), targetX);
                if (target1 != null && target2 != null) {
                    BirthmarkSet[] tmp = targetX;
                    targetX = targetY;
                    targetY = tmp;
                }
            }
            if (target1 == null || target2 == null) continue;
            this.pairList.add(new ComparisonPair(target1, target2, environment));
        }
        this.addSources(targetX);
        this.addSources(targetY);
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public int getComparisonCount() {
        return this.pairList.size();
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        return this.pairList.iterator();
    }

    @Override
    public BirthmarkSet[] getComparisonSources() {
        BirthmarkSet[] entries = new BirthmarkSet[this.sources.size()];
        int index = 0;
        for (Map.Entry<URL, BirthmarkSet> entry : this.sources.entrySet()) {
            entries[index] = entry.getValue();
            ++index;
        }
        return entries;
    }

    private BirthmarkSet findTarget(String className, BirthmarkSet[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (!className.equals(target[i].getName())) continue;
            return target[i];
        }
        return null;
    }

    private void addSources(BirthmarkSet[] bs) {
        for (BirthmarkSet s : bs) {
            this.sources.put(s.getLocation(), s);
        }
    }
}

