/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import jp.naist.se.stigmata.BirthmarkSpiComparator;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.filter.ComparisonPairFilterManager;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.utils.WellknownClassManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthmarkEnvironment {
    private static BirthmarkEnvironment DEFAULT_ENVIRONMENT = new BirthmarkEnvironment(true);
    private BirthmarkEnvironment parent;
    private ClasspathContext bytecodeContext;
    private WellknownClassManager manager;
    private Map<String, BirthmarkSpi> services = new HashMap<String, BirthmarkSpi>();
    private Map<String, String> properties = new HashMap<String, String>();
    private List<PropertyChangeListener> propertyListeners = new ArrayList<PropertyChangeListener>();
    private ComparisonPairFilterManager filterManager;
    private ExtractionUnit unit;

    private BirthmarkEnvironment(boolean flag) {
        this.manager = new WellknownClassManager();
        this.bytecodeContext = ClasspathContext.getDefaultContext();
        this.filterManager = new ComparisonPairFilterManager();
    }

    public BirthmarkEnvironment() {
        this(BirthmarkEnvironment.getDefaultEnvironment());
    }

    public BirthmarkEnvironment(BirthmarkEnvironment parent) {
        this.parent = parent;
        this.manager = new WellknownClassManager(parent.getWellknownClassManager());
        this.bytecodeContext = new ClasspathContext(parent.getClasspathContext());
        this.filterManager = new ComparisonPairFilterManager(parent.getFilterManager());
    }

    public static final BirthmarkEnvironment getDefaultEnvironment() {
        return DEFAULT_ENVIRONMENT;
    }

    public BirthmarkEnvironment getParent() {
        return this.parent;
    }

    public void removeProperty(String key) {
        String old = this.properties.get(key);
        this.properties.remove(key);
        this.firePropertyEvent(new PropertyChangeEvent(this, key, old, null));
    }

    public void addProperty(String key, String value) {
        String old = this.getProperty(key);
        this.properties.put(key, value);
        this.firePropertyEvent(new PropertyChangeEvent(this, key, old, value));
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value == null && this.parent != null) {
            value = this.parent.getProperty(key);
        }
        return value;
    }

    private void firePropertyEvent(PropertyChangeEvent e) {
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(e);
        }
    }

    public void addPropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.add(listener);
    }

    public void removePropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Iterator<String> propertyKeys() {
        HashSet<String> set = new HashSet<String>();
        if (this.parent != null) {
            Iterator<String> i = this.parent.propertyKeys();
            while (i.hasNext()) {
                set.add(i.next());
            }
        }
        set.addAll(this.properties.keySet());
        return set.iterator();
    }

    public ClasspathContext getClasspathContext() {
        return this.bytecodeContext;
    }

    public synchronized void addService(BirthmarkSpi service) {
        if (this.parent == null || this.parent.getService(service.getType()) == null) {
            this.services.put(service.getType(), service);
        }
    }

    public void removeService(String type) {
        this.services.remove(type);
    }

    public BirthmarkSpi getService(String type) {
        BirthmarkSpi service = this.services.get(type);
        if (service == null && this.parent != null) {
            service = this.parent.getService(type);
        }
        return service;
    }

    public synchronized BirthmarkSpi[] getServices() {
        List<BirthmarkSpi> list = this.getServiceList();
        BirthmarkSpi[] services = list.toArray(new BirthmarkSpi[list.size()]);
        Arrays.sort(services, new BirthmarkSpiComparator());
        return services;
    }

    public synchronized BirthmarkSpi[] findServices() {
        List<BirthmarkSpi> list = this.getServiceList();
        Iterator<BirthmarkSpi> i = ServiceRegistry.lookupProviders(BirthmarkSpi.class);
        while (i.hasNext()) {
            BirthmarkSpi spi = i.next();
            if (this.getService(spi.getType()) != null) continue;
            list.add(spi);
        }
        BirthmarkSpi[] services = list.toArray(new BirthmarkSpi[list.size()]);
        Arrays.sort(services, new BirthmarkSpiComparator());
        return services;
    }

    public WellknownClassManager getWellknownClassManager() {
        return this.manager;
    }

    private List<BirthmarkSpi> getServiceList() {
        ArrayList<BirthmarkSpi> list = new ArrayList<BirthmarkSpi>();
        if (this.parent != null) {
            for (BirthmarkSpi spi : this.parent.getServices()) {
                list.add(spi);
            }
        }
        for (String key : this.services.keySet()) {
            list.add(this.services.get(key));
        }
        return list;
    }

    public ComparisonPairFilterManager getFilterManager() {
        return this.filterManager;
    }

    public void setExtractionUnit(ExtractionUnit unit) {
        this.unit = unit;
    }

    public ExtractionUnit getExtractionUnit() {
        return this.unit;
    }
}

