/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.naist.se.stigmata.ComparisonMethod;
import jp.naist.se.stigmata.ExtractionUnit;
import jp.naist.se.stigmata.event.OperationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BirthmarkContext {
    private List<String> birthmarkTypes = new ArrayList<String>();
    private ComparisonMethod method = ComparisonMethod.ROUND_ROBIN;
    private ExtractionTarget et = ExtractionTarget.TARGET_X;
    private List<String> filterTypes = new ArrayList<String>();
    private Map<String, String> nameMappings = new HashMap<String, String>();
    private ExtractionUnit unit = ExtractionUnit.CLASS;
    private OperationType operation;

    public BirthmarkContext(OperationType type) {
        this.setOperation(type);
    }

    public OperationType getOperation() {
        return this.operation;
    }

    public void setOperation(OperationType operation) {
        this.operation = operation;
    }

    public void addNameMapping(String name1, String name2) {
        this.nameMappings.put(name1, name2);
    }

    public void removeNameMapping(String name1) {
        this.nameMappings.remove(name1);
    }

    public Map<String, String> getNameMappings() {
        return Collections.unmodifiableMap(this.nameMappings);
    }

    public void setExtractionTarget(ExtractionTarget target) {
        this.et = target;
    }

    public ExtractionTarget getExtractionTarget() {
        return this.et;
    }

    public void addExtractionType(String type) {
        this.birthmarkTypes.add(type);
    }

    public void removeExtractionType(String type) {
        this.birthmarkTypes.remove(type);
    }

    public synchronized String[] getExtractionTypes() {
        return this.birthmarkTypes.toArray(new String[this.getExtractionTypeCount()]);
    }

    public int getExtractionTypeCount() {
        return this.birthmarkTypes.size();
    }

    public ComparisonMethod getComparisonMethod() {
        return this.method;
    }

    public void setComparisonMethod(ComparisonMethod method) {
        this.method = method;
    }

    public ExtractionUnit getExtractionUnit() {
        return this.unit;
    }

    public void setExtractionUnit(ExtractionUnit unit) {
        this.unit = unit;
    }

    public void addFilterType(String filterType) {
        this.filterTypes.add(filterType);
    }

    public void removeFilterType(String filterType) {
        this.filterTypes.remove(filterType);
    }

    public synchronized String[] getFilterTypes() {
        return this.filterTypes.toArray(new String[this.getFilterTypesCount()]);
    }

    public Iterator<String> filterTypes() {
        return this.filterTypes.iterator();
    }

    public int getFilterTypesCount() {
        return this.filterTypes.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExtractionTarget {
        TARGET_X,
        TARGET_Y,
        TARGET_XY;

    }
}

