package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkExtractor.java 130 2007-06-13 10:08:01Z tama3 $
 */

import java.io.InputStream;

/**
 * extract birthmarks from given Java bytecode stream.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 130 $ $Date: 2007-06-13 19:08:01 +0900 (Wed, 13 Jun 2007) $
 */
public interface BirthmarkExtractor{
    /**
     * extract birthmark given stream.
     */
    public Birthmark extract(InputStream in) throws BirthmarkExtractionException;

    /**
     * extract birthmark given byte array.
     */
    public Birthmark extract(byte[] bytecode) throws BirthmarkExtractionException;

    /**
     * extract birthmark given stream with given context.
     */
    public Birthmark extract(InputStream in, BirthmarkContext context) throws BirthmarkExtractionException;

    /**
     * extract birthmark given byte array with given context.
     */
    public Birthmark extract(byte[] bytecode, BirthmarkContext context) throws BirthmarkExtractionException;
}
