package jp.naist.se.stigmata;

/*
 * $Id: AbstractBirthmarkExtractor.java 130 2007-06-13 10:08:01Z tama3 $
 */

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import jp.naist.se.stigmata.spi.BirthmarkSpi;

/**
 * Abstract class for extracting birthmark.
 * @author  Haruaki TAMADA
 * @version  $Revision: 130 $ $Date: 2007-06-13 19:08:01 +0900 (Wed, 13 Jun 2007) $
 */
public abstract class AbstractBirthmarkExtractor implements BirthmarkExtractor{
    /**
     * provider.
     */
    private BirthmarkSpi spi;

    /**
     * default constructor.
     * @deprecated this constructor does not support service provider.
     */
    public AbstractBirthmarkExtractor(){
    }

    /**
     * constructor.
     * @param spi service provider.
     */
    public AbstractBirthmarkExtractor(BirthmarkSpi spi){
        this.spi = spi;
    }

    /**
     * returns the provider of this extractor.
     */
    public BirthmarkSpi getProvider(){
        return spi;
    }

    /**
     * extract birthmark given stream.
     */
    public Birthmark extract(InputStream in) throws BirthmarkExtractionException{
        return extract(in, BirthmarkContext.getDefaultContext());
    }

    /**
     * extract birthmark given byte array.
     */
    public Birthmark extract(byte[] bytecode) throws BirthmarkExtractionException{
        return extract(bytecode, BirthmarkContext.getDefaultContext());
    }

    /**
     * extract birthmark given stream with given context.
     */
    public abstract Birthmark extract(InputStream in, BirthmarkContext context) throws BirthmarkExtractionException;

    /**
     * extract birthmark given byte array with given context.
     */
    public Birthmark extract(byte[] bytecode, BirthmarkContext context) throws BirthmarkExtractionException{
        return extract(new ByteArrayInputStream(bytecode), context);
    }
}
