/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jp.naist.se.stigmata.ui.swing.BinaryDataWritable;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.UnsupportedFormatException;
import jp.naist.se.stigmata.ui.swing.mds.MDSGraphViewer;

public class MDSImageExporter
implements BinaryDataWritable {
    private MDSGraphViewer viewer;

    public MDSImageExporter(MDSGraphViewer viewer) {
        this.viewer = viewer;
    }

    public void writeBinaryData(OutputStream out, String format) throws IOException, UnsupportedFormatException {
        Dimension size = this.viewer.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        this.viewer.update(g);
        try {
            ImageIO.write((RenderedImage)image, format, out);
            out.flush();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(SwingUtilities.getRoot(this.viewer), e.getMessage(), Messages.getString("error.dialog.title"), 2);
        }
    }
}

