/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.naist.se.stigmata.ui.swing.Messages;

public class Utility {
    private static final String iconPath = Messages.getString("icon.directory");

    private Utility() {
    }

    public static void decorateJComponent(JComponent component, String label) {
        if (Messages.hasString(String.valueOf(label) + ".tooltip")) {
            component.setToolTipText(Messages.getString(String.valueOf(label) + ".tooltip"));
        }
        if (Messages.hasString(String.valueOf(label) + ".border")) {
            component.setBorder(new TitledBorder(Messages.getString(String.valueOf(label) + ".border")));
        }
        try {
            Icon icon;
            if (component.getClass().getMethod("setIcon", new Class[0]) != null && (icon = Utility.getIcon(String.valueOf(label) + ".icon")) != null) {
                component.getClass().getMethod("setIcon", new Class[0]).invoke((Object)component, icon);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static JButton createButton(String label, Action action) {
        Icon icon;
        JButton button = new JButton(action);
        button.setText(Messages.getString(String.valueOf(label) + ".button.label"));
        button.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".button.tooltip")) {
            button.setToolTipText(Messages.getString(String.valueOf(label) + ".button.tooltip"));
        }
        if ((icon = Utility.getIcon(String.valueOf(label) + ".button.icon")) != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JButton createButton(String label) {
        Icon icon;
        JButton button = new JButton(Messages.getString(String.valueOf(label) + ".button.label"));
        button.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".button.tooltip")) {
            button.setToolTipText(Messages.getString(String.valueOf(label) + ".button.tooltip"));
        }
        if ((icon = Utility.getIcon(String.valueOf(label) + ".button.icon")) != null) {
            button.setIcon(icon);
        }
        return button;
    }

    public static JCheckBoxMenuItem createJCheckBoxMenuItem(String label) {
        return Utility.createJCheckBoxMenuItem(label, false);
    }

    public static JCheckBoxMenuItem createJCheckBoxMenuItem(String label, boolean status) {
        Icon icon;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString(String.valueOf(label) + ".menuitem.label"), status);
        item.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(String.valueOf(label) + ".menuitem.tooltip"));
        }
        if ((icon = Utility.getIcon(String.valueOf(label) + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenuItem createJMenuItem(String label, Action action) {
        Icon icon;
        JMenuItem item = new JMenuItem(action);
        item.setText(Messages.getString(String.valueOf(label) + ".menuitem.label"));
        item.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(String.valueOf(label) + ".menuitem.tooltip"));
        }
        if ((icon = Utility.getIcon(String.valueOf(label) + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenuItem createJMenuItem(String label) {
        Icon icon;
        JMenuItem item = new JMenuItem(Messages.getString(String.valueOf(label) + ".menuitem.label"));
        item.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menuitem.tooltip")) {
            item.setToolTipText(Messages.getString(String.valueOf(label) + ".menuitem.tooltip"));
        }
        if ((icon = Utility.getIcon(String.valueOf(label) + ".menuitem.icon")) != null) {
            item.setIcon(icon);
        }
        return item;
    }

    public static JMenu createJMenu(String label) {
        Icon icon;
        JMenu menu = new JMenu(Messages.getString(String.valueOf(label) + ".menu.label"));
        menu.setActionCommand(label);
        if (Messages.hasString(String.valueOf(label) + ".menu.tooltip")) {
            menu.setToolTipText(Messages.getString(String.valueOf(label) + ".menu.tooltip"));
        }
        if ((icon = Utility.getIcon(String.valueOf(label) + ".menu.icon")) != null) {
            menu.setIcon(icon);
        }
        return menu;
    }

    public static Icon getIcon(String label) {
        if (Messages.hasString(label)) {
            String iconFile = Messages.getString(label);
            ImageIcon icon = new ImageIcon(Utility.class.getResource(String.valueOf(iconPath) + iconFile));
            return icon;
        }
        return null;
    }

    public static String array2String(String[] values) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(values[i]);
            ++i;
        }
        return new String(builder);
    }

    public static void addNewTab(String key, JTabbedPane tabPane, Component comp) {
        Utility.addNewTab(key, tabPane, comp, null, null);
    }

    public static void addNewTab(String key, JTabbedPane tabPane, Component comp, Object[] tabnameValues, Object[] values) {
        String tabName = Messages.getString(String.valueOf(key) + ".tab.label");
        String tooltip = Messages.getString(String.valueOf(key) + ".tab.tooltip");
        Icon icon = Utility.getIcon(String.valueOf(key) + ".tab.icon");
        if (tabnameValues != null) {
            tabName = MessageFormat.format(tabName, tabnameValues);
        }
        if (values != null) {
            tooltip = MessageFormat.format(tooltip, values);
        }
        tabPane.addTab(tabName, icon, comp, tooltip);
    }
}

