/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.format.FormatManager;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.AsciiDataWritable;
import jp.naist.se.stigmata.ui.swing.ClassNameObfuscator;
import jp.naist.se.stigmata.ui.swing.CompareTableCellRenderer;
import jp.naist.se.stigmata.ui.swing.FilterSelectionPane;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PopupButton;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;

public class RoundRobinComparisonResultPane
extends JPanel {
    private static final long serialVersionUID = 2134574576543623L;
    private List<BirthmarkSet> birthmarksX;
    private List<BirthmarkSet> birthmarksY;
    private JTable table;
    private DefaultTableModel model;
    private JLabel classCount;
    private JLabel comparisonCount;
    private JLabel distinctionRatio;
    private JLabel average;
    private JLabel minimum;
    private JLabel maximum;
    private StigmataFrame stigmataFrame;
    private BirthmarkContext context;

    public RoundRobinComparisonResultPane(StigmataFrame stigmata, BirthmarkContext context, BirthmarkSet[] birthmarksX, BirthmarkSet[] birthmarksY) {
        this.stigmataFrame = stigmata;
        this.context = context;
        this.birthmarksX = Arrays.asList(birthmarksX);
        this.birthmarksY = Arrays.asList(birthmarksY);
        this.initialize();
        this.compare(this.model);
    }

    private void compare(DefaultTableModel model) {
        int comparison = this.birthmarksX.size() * this.birthmarksY.size();
        this.classCount.setText(Integer.toString(this.birthmarksX.size() + this.birthmarksY.size()));
        this.comparisonCount.setText(Integer.toString(comparison));
        int correct = 0;
        double avg = 0.0;
        double max = 0.0;
        double min = 100.0;
        model.addColumn("");
        for (BirthmarkSet x : this.birthmarksX) {
            model.addColumn(x.getName());
        }
        int j = 0;
        while (j < this.birthmarksY.size()) {
            Object[] rows = new Object[this.birthmarksX.size() + 1];
            rows[0] = this.birthmarksY.get(j).getName();
            int i = 0;
            while (i < this.birthmarksX.size()) {
                double similarity = this.compare(this.context, this.birthmarksX.get(i), this.birthmarksY.get(j));
                rows[i + 1] = new Double(similarity);
                if (Math.abs(similarity - 1.0) < 1.0E-8) {
                    ++correct;
                }
                avg += similarity;
                if (max < similarity) {
                    max = similarity;
                }
                if (min > similarity) {
                    min = similarity;
                }
                ++i;
            }
            model.addRow(rows);
            ++j;
        }
        this.distinctionRatio.setText(Double.toString((double)(comparison - correct) / (double)comparison));
        this.average.setText(Double.toString(avg /= (double)comparison));
        this.minimum.setText(Double.toString(min));
        this.maximum.setText(Double.toString(max));
    }

    private double compare(BirthmarkContext context, BirthmarkSet x, BirthmarkSet y) {
        double similarity = 0.0;
        int count = 0;
        String[] stringArray = x.getBirthmarkTypes();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            BirthmarkComparator comparator;
            double result;
            String type = stringArray[n];
            Birthmark b1 = x.getBirthmark(type);
            Birthmark b2 = y.getBirthmark(type);
            if (b1 != null && b2 != null && (result = (comparator = context.getService(type).getComparator()).compare(b1, b2)) != Double.NaN) {
                similarity += result;
                ++count;
            }
            ++n;
        }
        return similarity / (double)count;
    }

    private Component getMainPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.model = new RoundRobinComparisonResultSetTableModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Double.class, new CompareTableCellRenderer());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = RoundRobinComparisonResultPane.this.table.rowAtPoint(e.getPoint());
                    int col = RoundRobinComparisonResultPane.this.table.columnAtPoint(e.getPoint());
                    if (col >= 1 && col < RoundRobinComparisonResultPane.this.table.getColumnCount() && row >= 0 && row < RoundRobinComparisonResultPane.this.table.getRowCount()) {
                        BirthmarkSet b1 = (BirthmarkSet)RoundRobinComparisonResultPane.this.birthmarksX.get(col - 1);
                        BirthmarkSet b2 = (BirthmarkSet)RoundRobinComparisonResultPane.this.birthmarksY.get(row);
                        RoundRobinComparisonResultPane.this.stigmataFrame.compareDetails(b1, b2, RoundRobinComparisonResultPane.this.context);
                    }
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.table);
        scroll.setWheelScrollingEnabled(true);
        panel.add((Component)scroll, "Center");
        Box south = Box.createVerticalBox();
        JPanel box1 = new JPanel(new GridLayout(1, 3));
        this.classCount = new JLabel();
        box1.add(this.classCount);
        this.comparisonCount = new JLabel();
        box1.add(this.comparisonCount);
        this.distinctionRatio = new JLabel();
        box1.add(this.distinctionRatio);
        south.add(box1);
        JPanel box2 = new JPanel(new GridLayout(1, 3));
        box2.setBorder(new TitledBorder(Messages.getString("similarity.border")));
        this.average = new JLabel();
        box2.add(this.average);
        this.minimum = new JLabel();
        box2.add(this.minimum);
        this.maximum = new JLabel();
        box2.add(this.maximum);
        south.add(box2);
        this.classCount.setBorder(new TitledBorder(Messages.getString("numberofclasses.border")));
        this.comparisonCount.setBorder(new TitledBorder(Messages.getString("comparisoncount.border")));
        this.distinctionRatio.setBorder(new TitledBorder(Messages.getString("distinctionratio.border")));
        this.average.setBorder(new TitledBorder(Messages.getString("average.border")));
        this.minimum.setBorder(new TitledBorder(Messages.getString("minimum.border")));
        this.maximum.setBorder(new TitledBorder(Messages.getString("maximum.border")));
        panel.add((Component)south, "South");
        return panel;
    }

    private void mdsButtonActionPerformed(ActionEvent e) {
        HashMap<URL, BirthmarkSet> map = new HashMap<URL, BirthmarkSet>();
        for (BirthmarkSet bs : this.birthmarksX) {
            map.put(bs.getLocation(), bs);
        }
        for (BirthmarkSet bs : this.birthmarksY) {
            map.put(bs.getLocation(), bs);
        }
        int index = 0;
        BirthmarkSet[] set = new BirthmarkSet[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            set[index] = (BirthmarkSet)entry.getValue();
            ++index;
        }
        this.stigmataFrame.showMDSGraph(set);
    }

    private void graphButtonActionPerformed(ActionEvent e) {
        HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < this.table.getRowCount()) {
            int j = 1;
            while (j < this.table.getColumnCount()) {
                Double d = (Double)this.table.getValueAt(i, j);
                int similarity = (int)Math.round(d * 100.0);
                Integer dist = (Integer)values.get(new Integer(similarity));
                if (dist == null) {
                    dist = new Integer(0);
                }
                dist = new Integer(dist + 1);
                values.put(new Integer(similarity), dist);
                ++j;
            }
            ++i;
        }
        this.stigmataFrame.showSimilarityDistributionGraph(values);
    }

    private void initialize() {
        JButton save = Utility.createButton("savecomparison", new SaveAction(this.stigmataFrame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) {
                ResultFormatSpi service = FormatManager.getInstance().getService(format);
                if (service == null) {
                    service = FormatManager.getDefaultFormatService();
                }
                service.getComparisonResultFormat().printResult(out, new RoundRobinComparisonResultSet(RoundRobinComparisonResultPane.this.birthmarksX.toArray(new BirthmarkSet[RoundRobinComparisonResultPane.this.birthmarksX.size()]), RoundRobinComparisonResultPane.this.birthmarksY.toArray(new BirthmarkSet[RoundRobinComparisonResultPane.this.birthmarksY.size()]), RoundRobinComparisonResultPane.this.context));
            }
        }));
        JButton graph = Utility.createButton("showgraph");
        JButton obfuscate = Utility.createButton("obfuscate");
        JButton compare = Utility.createButton("guessedpair");
        JMenuItem mdsMenu = Utility.createJMenuItem("mdsmap");
        PopupButton comparePopup = new PopupButton(compare);
        PopupButton graphPopup = new PopupButton(graph);
        Box southPanel = Box.createHorizontalBox();
        this.setLayout(new BorderLayout());
        this.add(this.getMainPane(), "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(save);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(graphPopup);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(obfuscate);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(comparePopup);
        southPanel.add(Box.createHorizontalGlue());
        graph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.graphButtonActionPerformed(e);
            }
        });
        mdsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.mdsButtonActionPerformed(e);
            }
        });
        obfuscate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.obfuscateClassNames();
            }
        });
        ActionListener compareListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = e.getActionCommand();
                if (item.equals("guessedpair")) {
                    RoundRobinComparisonResultPane.this.compareGuessedPair();
                } else if (item.equals("specifiedpair")) {
                    RoundRobinComparisonResultPane.this.compareSpecifiedPair();
                } else if (item.equals("roundrobin.filtering")) {
                    RoundRobinComparisonResultPane.this.compareRoundRobinWithFiltering();
                }
            }
        };
        compare.addActionListener(compareListener);
        String[] comparisonMethods = Messages.getStringArray("comparison.methods.inroundrobinresult");
        int i = 1;
        while (i < comparisonMethods.length) {
            JMenuItem item = Utility.createJMenuItem(comparisonMethods[i]);
            comparePopup.addMenuItem(item);
            item.addActionListener(compareListener);
            ++i;
        }
        graphPopup.addMenuItem(mdsMenu);
    }

    private void compareRoundRobinWithFiltering() {
        FilterSelectionPane pane = new FilterSelectionPane(this.context.getFilterManager());
        int returnValue = JOptionPane.showConfirmDialog(this.stigmataFrame, pane, Messages.getString("filterselection.dialog.title"), 2, 3);
        if (returnValue == 0) {
            String[] filterSetList = pane.getSelectedFilters();
            RoundRobinComparisonResultSet resultset = new RoundRobinComparisonResultSet(this.birthmarksX.toArray(new BirthmarkSet[this.birthmarksX.size()]), this.birthmarksY.toArray(new BirthmarkSet[this.birthmarksY.size()]), this.context);
            FilteredComparisonResultSet filterResultSet = new FilteredComparisonResultSet(resultset, this.context.getFilterManager().getFilterSets(filterSetList));
            this.stigmataFrame.showComparisonResultSet(filterResultSet);
        }
    }

    private void compareGuessedPair() {
        CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(this.birthmarksX.toArray(new BirthmarkSet[this.birthmarksX.size()]), this.birthmarksY.toArray(new BirthmarkSet[this.birthmarksY.size()]), this.context);
        this.stigmataFrame.showComparisonResultSet(resultset);
    }

    private void compareSpecifiedPair() {
        File file = this.stigmataFrame.getOpenFile(Messages.getStringArray("comparemapping.extension"), Messages.getString("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.stigmataFrame.constructMapping(file);
            CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(this.birthmarksX.toArray(new BirthmarkSet[this.birthmarksX.size()]), this.birthmarksY.toArray(new BirthmarkSet[this.birthmarksY.size()]), mapping, this.context);
            this.stigmataFrame.showComparisonResultSet(resultset);
        }
    }

    private void obfuscateClassNames() {
        ClassNameObfuscator obfuscator = new ClassNameObfuscator();
        try {
            File file = this.stigmataFrame.getSaveFile(Messages.getStringArray("obfuscationmapping.extension"), Messages.getString("obfuscationmapping.description"));
            if (file != null) {
                int i = 0;
                while (i < this.birthmarksX.size()) {
                    this.birthmarksX.set(i, obfuscator.obfuscateClassName(this.birthmarksX.get(i)));
                    ++i;
                }
                i = 0;
                while (i < this.birthmarksY.size()) {
                    this.birthmarksY.set(i, obfuscator.obfuscateClassName(this.birthmarksY.get(i)));
                    ++i;
                }
                obfuscator.outputNameMappings(file);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("error.dialog.title"), 0);
            return;
        }
        RoundRobinComparisonResultSetTableModel model = new RoundRobinComparisonResultSetTableModel();
        this.compare(model);
        this.table.setModel(model);
        this.model = model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoundRobinComparisonResultSetTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 765435324523543242L;

        private RoundRobinComparisonResultSetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            return Double.class;
        }
    }
}

