/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.comparators;

import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class EditDistanceBirthmarkComparator
implements BirthmarkComparator {
    private BirthmarkSpi spi;

    public EditDistanceBirthmarkComparator() {
    }

    public EditDistanceBirthmarkComparator(BirthmarkSpi spi) {
        this.spi = spi;
    }

    public BirthmarkSpi getProvider() {
        return this.spi;
    }

    public String getType() {
        return this.spi.getType();
    }

    public double compare(Birthmark b1, Birthmark b2) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        int[][] distance = this.createDistanceMatrics(element1, element2);
        int length = element1.length;
        if (length < element2.length) {
            length = element2.length;
        }
        int d = distance[element1.length][element2.length];
        if (element1.length == 0 && element2.length == 0) {
            return 1.0;
        }
        return (double)(length - d) / (double)length;
    }

    public int getCompareCount(Birthmark b1, Birthmark b2) {
        return b1.getElementCount() + b2.getElementCount();
    }

    protected int[][] createDistanceMatrics(BirthmarkElement[] element1, BirthmarkElement[] element2) {
        int[][] distance = new int[element1.length + 1][element2.length + 1];
        int i = 0;
        while (i <= element1.length) {
            distance[i][0] = i;
            ++i;
        }
        i = 0;
        while (i <= element2.length) {
            distance[0][i] = i;
            ++i;
        }
        i = 1;
        while (i <= element1.length) {
            int j = 1;
            while (j <= element2.length) {
                int cost = 1;
                cost = element1[i - 1] == null ? (element2[j - 1] == null ? 0 : 1) : (element1[i - 1].equals(element2[j - 1]) ? 0 : 1);
                int insertion = distance[i - 1][j] + 1;
                int deletion = distance[i][j - 1] + 1;
                int replace = distance[i - 1][j - 1] + cost;
                distance[i][j] = insertion <= deletion && insertion <= replace ? insertion : (deletion <= replace ? deletion : replace);
                ++j;
            }
            ++i;
        }
        return distance;
    }
}

