/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertainPairComparisonResultSet
implements ComparisonResultSet {
    private BirthmarkContext context;
    private List<ComparisonPair> pairList = new ArrayList<ComparisonPair>();
    private Map<URL, BirthmarkSet> sources = new HashMap<URL, BirthmarkSet>();

    public CertainPairComparisonResultSet(ComparisonPair[] pairs, BirthmarkContext context) {
        this.context = context;
        int i = 0;
        while (i < pairs.length) {
            this.pairList.add(pairs[i]);
            this.sources.put(pairs[i].getTarget1().getLocation(), pairs[i].getTarget1());
            this.sources.put(pairs[i].getTarget2().getLocation(), pairs[i].getTarget2());
            ++i;
        }
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, BirthmarkContext context) {
        this.context = context;
        int i = 0;
        while (i < targetX.length) {
            BirthmarkSet target2 = this.findTarget(targetX[i].getName(), targetY);
            if (target2 != null) {
                this.pairList.add(new ComparisonPair(targetX[i], target2, context));
            }
            ++i;
        }
        this.addSources(targetX);
        this.addSources(targetY);
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, Map<String, String> mapping, BirthmarkContext context) {
        this.context = context;
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            BirthmarkSet target1 = this.findTarget(entry.getKey(), targetX);
            BirthmarkSet target2 = this.findTarget(entry.getValue(), targetY);
            if (target1 == null && target2 == null) {
                target1 = this.findTarget(entry.getKey(), targetY);
                target2 = this.findTarget(entry.getValue(), targetX);
                if (target1 != null && target2 != null) {
                    BirthmarkSet[] tmp = targetX;
                    targetX = targetY;
                    targetY = tmp;
                }
            }
            if (target1 == null || target2 == null) continue;
            this.pairList.add(new ComparisonPair(target1, target2, context));
        }
        this.addSources(targetX);
        this.addSources(targetY);
    }

    @Override
    public BirthmarkContext getContext() {
        return this.context;
    }

    @Override
    public int getComparisonCount() {
        return this.pairList.size();
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        return this.pairList.iterator();
    }

    @Override
    public BirthmarkSet[] getComparisonSources() {
        BirthmarkSet[] entries = new BirthmarkSet[this.sources.size()];
        int index = 0;
        for (Map.Entry<URL, BirthmarkSet> entry : this.sources.entrySet()) {
            entries[index] = entry.getValue();
            ++index;
        }
        return entries;
    }

    private BirthmarkSet findTarget(String className, BirthmarkSet[] target) {
        int i = 0;
        while (i < target.length) {
            if (className.equals(target[i].getName())) {
                return target[i];
            }
            ++i;
        }
        return null;
    }

    private void addSources(BirthmarkSet[] bs) {
        BirthmarkSet[] birthmarkSetArray = bs;
        int n = 0;
        int n2 = birthmarkSetArray.length;
        while (n < n2) {
            BirthmarkSet s = birthmarkSetArray[n];
            this.sources.put(s.getLocation(), s);
            ++n;
        }
    }
}

