/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.format.csv;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairElement;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.format.AbstractBirthmarkComparisonResultFormat;
import jp.naist.se.stigmata.format.csv.BirthmarkExtractionResultCsvFormat;

public class BirthmarkComparisonResultCsvFormat
extends AbstractBirthmarkComparisonResultFormat {
    private BirthmarkExtractionResultCsvFormat list;

    public BirthmarkComparisonResultCsvFormat(BirthmarkExtractionResultCsvFormat list) {
        this.list = list;
    }

    public void printResult(PrintWriter out, ComparisonPair pair) {
        this.list.printBirthmarkHolder(out, pair.getTarget1());
        this.list.printBirthmarkHolder(out, pair.getTarget2());
        for (ComparisonPairElement element : pair) {
            out.print("compare,");
            out.print(element.getType());
            out.print(",");
            out.println(element.getSimilarity());
        }
        out.flush();
    }

    public void printResult(PrintWriter out, ComparisonResultSet resultset) {
        if (resultset instanceof CertainPairComparisonResultSet) {
            this.printResultImpl(out, (CertainPairComparisonResultSet)resultset);
        } else {
            this.printResultImpl(out, resultset);
        }
    }

    private void printResultImpl(PrintWriter out, CertainPairComparisonResultSet resultset) {
        for (ComparisonPair pair : resultset) {
            out.print(pair.getTarget1().getName());
            out.print(",");
            out.print(pair.getTarget1().getName());
            out.print(",");
            out.println(pair.calculateSimilarity());
        }
    }

    private void printResultImpl(PrintWriter out, ComparisonResultSet resultset) {
        LinkedHashMap<String, HashMap<String, Double>> map = new LinkedHashMap<String, HashMap<String, Double>>();
        ArrayList<String> names = new ArrayList<String>();
        for (ComparisonPair comparisonPair : resultset) {
            HashMap<String, Double> val = (HashMap<String, Double>)map.get(comparisonPair.getTarget1().getName());
            if (val == null) {
                val = new HashMap<String, Double>();
            }
            val.put(comparisonPair.getTarget2().getName(), new Double(comparisonPair.calculateSimilarity()));
            if (!names.contains(comparisonPair.getTarget2().getName())) {
                names.add(comparisonPair.getTarget2().getName());
            }
            map.put(comparisonPair.getTarget1().getName(), val);
        }
        for (String string : names) {
            out.print(",");
            out.print(string);
        }
        out.println();
        for (Map.Entry entry : map.entrySet()) {
            out.print((String)entry.getKey());
            Map element = (Map)entry.getValue();
            for (String name : names) {
                out.print(",");
                Double v = (Double)element.get(name);
                if (v == null) continue;
                out.print(v);
            }
            out.println();
        }
        out.flush();
    }
}

