/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.filter;

import java.util.ArrayList;
import java.util.List;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.filter.AbstractComparisonPairFilter;
import jp.naist.se.stigmata.filter.Criterion;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;

public class SimilarityComparisonPairFilter
extends AbstractComparisonPairFilter {
    private static final double EQUALS_THRESHOLD = 5.0E-5;
    private static List<Criterion> CRITERIA = new ArrayList<Criterion>();
    private double threshold;

    static {
        CRITERIA.add(Criterion.GREATER_EQUALS);
        CRITERIA.add(Criterion.GREATER_THAN);
        CRITERIA.add(Criterion.LESS_EQUALS);
        CRITERIA.add(Criterion.LESS_THAN);
        CRITERIA.add(Criterion.EQUALS_AS);
        CRITERIA.add(Criterion.NOT_EQUALS_AS);
    }

    public SimilarityComparisonPairFilter(ComparisonPairFilterSpi service) {
        super(service);
        this.setThreshold(0.8);
    }

    public boolean isFiltered(ComparisonPair pair) {
        boolean flag;
        double similarity = pair.calculateSimilarity();
        switch (this.getCriterion()) {
            case GREATER_EQUALS: {
                flag = similarity >= this.getThreshold();
                break;
            }
            case GREATER_THAN: {
                flag = similarity > this.getThreshold();
                break;
            }
            case LESS_EQUALS: {
                flag = similarity <= this.getThreshold();
                break;
            }
            case LESS_THAN: {
                flag = similarity < this.getThreshold();
                break;
            }
            case EQUALS_AS: {
                flag = similarity - this.getThreshold() <= 5.0E-5;
                break;
            }
            case NOT_EQUALS_AS: {
                flag = similarity - this.getThreshold() > 5.0E-5;
                break;
            }
            default: {
                flag = false;
            }
        }
        return flag;
    }

    public static Criterion[] getValidCriteria() {
        return CRITERIA.toArray(new Criterion[CRITERIA.size()]);
    }

    public Criterion[] getAcceptableCriteria() {
        return SimilarityComparisonPairFilter.getValidCriteria();
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        if (threshold < 0.0 || threshold >= 1.0) {
            throw new IllegalArgumentException("threshold must be 0.0-1.0");
        }
        this.threshold = threshold;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("similarity");
        switch (this.getCriterion()) {
            case GREATER_EQUALS: {
                sb.append(" >= ");
                break;
            }
            case GREATER_THAN: {
                sb.append(" >  ");
                break;
            }
            case LESS_EQUALS: {
                sb.append(" <= ");
                break;
            }
            case LESS_THAN: {
                sb.append(" <  ");
                break;
            }
            case EQUALS_AS: {
                sb.append(" == ");
                break;
            }
            case NOT_EQUALS_AS: {
                sb.append(" != ");
            }
        }
        sb.append(this.getThreshold());
        return new String(sb);
    }
}

