package jp.naist.se.stigmata;

/*
 * $Id: StigmataTest.java 90 2007-03-29 05:54:27Z tama3 $
 */

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import jp.naist.se.stigmata.spi.BirthmarkSpi;

/**
 * test case.
 * @author Haruaki TAMADA
 * @version $Revision: 90 $ $Date: 2007-03-29 14:54:27 +0900 (Thu, 29 Mar 2007) $
 */
public class StigmataTest{
    private BirthmarkContext context;

    @Before
    public void prepare(){
        context = Stigmata.getInstance().createContext();
    }

    @Test
    public void checkAvailableServices() throws Exception{
        Assert.assertNotNull(context.getService("smc"));
        Assert.assertNotNull(context.getService("cvfv"));
        Assert.assertNotNull(context.getService("is"));
        Assert.assertNotNull(context.getService("uc"));
    }

    @Test
    public void checkSmcBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("smc");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.comparators.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.smc.SequentialMethodCallBirthmarkExtractor"
        );
    }

    @Test
    public void checkCvfvBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("cvfv");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.comparators.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.cvfv.ConstantValueOfFieldVariableBirthmarkExtractor"
        );
    }

    @Test
    public void checkIsBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("is");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.comparators.PlainBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.is.InheritanceStructureBirthmarkExtractor"
        );
    }

    @Test
    public void checkUcBirthmarkService() throws Exception{
        BirthmarkSpi service = context.getService("uc");

        Assert.assertNotNull(service.getComparator());
        Assert.assertNotNull(service.getExtractor());
        Assert.assertEquals(
            service.getComparator().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.comparators.LogicalAndBirthmarkComparator"
        );
        Assert.assertEquals(
            service.getExtractor().getClass().getName(),
            "jp.naist.se.stigmata.birthmarks.uc.UsedClassesBirthmarkExtractor"
        );
    }
}
