package jp.naist.se.stigmata.format.csv;

/*
 * $Id: CsvResultFormatService.java 74 2007-03-12 05:26:27Z tama3 $
 */

import java.util.Locale;

import jp.naist.se.stigmata.format.BirthmarkComparisonResultFormat;
import jp.naist.se.stigmata.format.BirthmarkExtractionResultFormat;
import jp.naist.se.stigmata.format.BirthmarkServiceListFormat;
import jp.naist.se.stigmata.spi.AbstractServiceProvider;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.utils.LocalizedDescriptionManager;

/**
 * 
 * 
 *
 * @author Haruaki TAMADA
 * @version $Revision: 74 $ $Date: 2007-03-12 14:26:27 +0900 (Mon, 12 Mar 2007) $
 */
public class CsvResultFormatService extends AbstractServiceProvider implements ResultFormatSpi{
    private BirthmarkServiceListCsvFormat serviceList = new BirthmarkServiceListCsvFormat();
    private BirthmarkExtractionResultCsvFormat list = new BirthmarkExtractionResultCsvFormat();
    private BirthmarkComparisonResultCsvFormat compare = new BirthmarkComparisonResultCsvFormat(list);

    /**
     * returns a localized description of the birthmark this service provides.
     */
    public String getDescription(Locale locale){
        return LocalizedDescriptionManager.getInstance().getDescription(
            locale, getFormat(), LocalizedDescriptionManager.ServiceCategory.formatter
        );
    }

    public String getFormat(){
        return "csv";
    }
    
    public BirthmarkComparisonResultFormat getComparisonResultFormat() {
        return compare;
    }

    public BirthmarkExtractionResultFormat getExtractionResultFormat() {
        return list;
    }

    public BirthmarkServiceListFormat getBirthmarkServiceListFormat() {
        return serviceList;
    }

    
}
