/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElementClassNotFoundException;
import jp.naist.se.stigmata.BirthmarkExtractionException;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.format.FormatManager;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkDataWritable;
import jp.naist.se.stigmata.ui.swing.BirthmarkExtractionResultPane;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.ControlPane;
import jp.naist.se.stigmata.ui.swing.CurrentDirectoryHolder;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PairComparisonPane;
import jp.naist.se.stigmata.ui.swing.PairComparisonResultSetPane;
import jp.naist.se.stigmata.ui.swing.RoundRobinComparisonResultPane;
import jp.naist.se.stigmata.ui.swing.SimilarityGraphPane;
import jp.naist.se.stigmata.ui.swing.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StigmataFrame
extends JFrame
implements CurrentDirectoryHolder {
    private static final long serialVersionUID = 92345543665342134L;
    private static List<JFrame> frameList = new ArrayList<JFrame>();
    private JTabbedPane tabPane;
    private JMenuItem closeTabMenu;
    private JCheckBoxMenuItem expertmodeMenu;
    private Stigmata stigmata;
    private BirthmarkContext context;
    private ControlPane control;
    private File currentDirectory;
    private int extractCount = 0;
    private int compareCount = 0;
    private int compareDetail = 0;
    private int graphCount = 0;
    private int comparePair = 0;

    public StigmataFrame() {
        this.stigmata = Stigmata.getInstance();
        this.context = this.stigmata.createContext();
        this.initLayouts();
    }

    public StigmataFrame(Stigmata stigmata) {
        this(stigmata, stigmata.createContext());
    }

    public StigmataFrame(Stigmata stigmata, BirthmarkContext context) {
        this.stigmata = stigmata;
        this.context = context;
        this.initLayouts();
    }

    @Override
    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public void setCurrentDirectory(File directory) {
        if (!directory.isDirectory()) {
            JOptionPane.showMessageDialog(this, Messages.getString("notdirectory.dialog.message", directory.getName()), Messages.getString("notdirectory.dialog.title"), 0);
            return;
        }
        this.currentDirectory = directory;
    }

    public Stigmata getStigmata() {
        return this.stigmata;
    }

    public BirthmarkContext getContext() {
        return this.context;
    }

    public File getOpenFile(String[] exts, String desc) {
        return this.findFile(true, exts, desc);
    }

    public File getSaveFile(String[] exts, String desc) {
        return this.findFile(false, exts, desc);
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.addBirthmarkServiceListener(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.control.removeBirthmarkServiceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAction(BirthmarkDataWritable writable) {
        File file = this.getSaveFile(Messages.getStringArray("store.extensions"), Messages.getString("store.description"));
        if (file != null) {
            String name = file.getName();
            String ext = name.substring(name.lastIndexOf(46) + 1, name.length());
            ResultFormatSpi result = FormatManager.getInstance().getService(ext);
            if (result == null) {
                result = FormatManager.getDefaultFormatService();
            }
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(file));
                writable.writeData(out, result);
            }
            catch (IOException e) {
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public void compareDetails(BirthmarkSet target1, BirthmarkSet target2, BirthmarkContext context) {
        PairComparisonPane detail = new PairComparisonPane(this, new ComparisonPair(target1, target2, context));
        ++this.compareDetail;
        Utility.addNewTab("comparedetail", this.tabPane, detail, new Object[]{new Integer(this.compareDetail)}, new Object[]{Utility.array2String(target1.getBirthmarkTypes()), target1.getClassName(), target2.getClassName()});
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void compareRoundRobin(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
            RoundRobinComparisonResultPane compare = new RoundRobinComparisonResultPane(this, context, x, y);
            ++this.compareCount;
            Utility.addNewTab("compare", this.tabPane, compare, new Object[]{new Integer(this.compareCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareRoundRobin(String[] birthmarks, String[] targetX, String[] targetY, String[] filterNames, BirthmarkContext context) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
            ComparisonPairFilterSet[] filters = context.getFilterManager().getFilterSets(filterNames);
            ComparisonResultSet resultset = this.stigmata.compare(x, y, context);
            FilteredComparisonResultSet fcrs = new FilteredComparisonResultSet(resultset, filters);
            ++this.compareCount;
            Utility.addNewTab("compare", this.tabPane, new PairComparisonResultSetPane(this, fcrs), new Object[]{new Integer(this.compareCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareGuessedPair(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkContext context) {
        try {
            BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
            BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
            ++this.comparePair;
            CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(x, y, context);
            Utility.addNewTab("comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(this.comparePair)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    public void compareSpecifiedPair(String[] birthmarks, String[] targetX, String[] targetY, BirthmarkContext context) {
        File file = this.getOpenFile(Messages.getStringArray("comparemapping.extension"), Messages.getString("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.constructMapping(file);
            try {
                BirthmarkSet[] x = this.stigmata.extract(birthmarks, targetX, context);
                BirthmarkSet[] y = this.stigmata.extract(birthmarks, targetY, context);
                ++this.comparePair;
                CertainPairComparisonResultSet resultset = new CertainPairComparisonResultSet(x, y, mapping, context);
                Utility.addNewTab("comparepair", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(this.comparePair)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targetX), Utility.array2String(targetY)});
                this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
            }
            catch (Exception e) {
                this.showExceptionMessage(e);
            }
        }
    }

    public void showComparisonResultSet(ComparisonResultSet resultset) {
        ++this.comparePair;
        Utility.addNewTab("comparisonresultset", this.tabPane, new PairComparisonResultSetPane(this, resultset), new Object[]{new Integer(this.comparePair)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void showGraph(Map<Integer, Integer> distributions) {
        SimilarityGraphPane graph = new SimilarityGraphPane(distributions);
        JPanel graphPanel = new JPanel(new FlowLayout(1));
        graphPanel.add(graph);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)graphPanel, "Center");
        ++this.graphCount;
        Utility.addNewTab("graph", this.tabPane, panel, new Object[]{new Integer(this.graphCount)}, null);
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    public void extract(String[] birthmarks, String[] targets, BirthmarkContext context) {
        try {
            BirthmarkSet[] holders = this.stigmata.extract(birthmarks, targets, context);
            ++this.extractCount;
            BirthmarkExtractionResultPane viewer = new BirthmarkExtractionResultPane(this, context, holders);
            Utility.addNewTab("extract", this.tabPane, viewer, new Object[]{new Integer(this.extractCount)}, new Object[]{Utility.array2String(birthmarks), Utility.array2String(targets)});
            this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> constructMapping(File file) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split(", *");
                if (tokens.length < 2) continue;
                mapping.put(tokens[0], tokens[1]);
            }
        }
        catch (Exception e) {
            this.showExceptionMessage(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return mapping;
    }

    private File findFile(boolean open, String[] exts, String desc) {
        JFileChooser chooser = new JFileChooser(this.getCurrentDirectory());
        chooser.setFileFilter(new ExtensionFilter(exts, desc));
        int returnValue = -1;
        returnValue = open ? chooser.showOpenDialog(SwingUtilities.getRootPane(this)) : chooser.showSaveDialog(SwingUtilities.getRootPane(this));
        if (returnValue == 0) {
            this.setCurrentDirectory(chooser.getCurrentDirectory());
            return chooser.getSelectedFile();
        }
        return null;
    }

    private void initLayouts() {
        this.setTitle(Messages.getString("stigmata.frame.title"));
        this.initComponents();
        this.control = new ControlPane(this);
        Utility.addNewTab("control", this.tabPane, this.control, null, null);
        this.control.inititalize();
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
        this.currentDirectory = new File(".");
        this.setSize(900, 600);
        frameList.add(this);
    }

    private void initComponents() {
        this.tabPane = new JTabbedPane();
        this.add((Component)this.tabPane, "Center");
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                String title = StigmataFrame.this.tabPane.getTitleAt(StigmataFrame.this.tabPane.getSelectedIndex());
                StigmataFrame.this.closeTabMenu.setEnabled(!title.equals(Messages.getString("control.tab.label")));
            }
        });
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.createFileMenu());
        menubar.add(this.createHelpMenu());
        this.setJMenuBar(menubar);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                StigmataFrame.this.formWindowClosed(evt);
            }
        });
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = Utility.createJMenu("fileMenu");
        JMenuItem newFrameMenu = Utility.createJMenuItem("newframe");
        JMenuItem exportMenu = Utility.createJMenuItem("exportsetting");
        JMenuItem closeTabMenu = Utility.createJMenuItem("closetab");
        JMenuItem closeMenu = Utility.createJMenuItem("closeframe");
        JMenuItem exitMenu = Utility.createJMenuItem("exit");
        this.closeTabMenu = closeTabMenu;
        fileMenu.add(newFrameMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exportMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(closeTabMenu);
        fileMenu.add(closeMenu);
        fileMenu.add(new JSeparator());
        fileMenu.add(exitMenu);
        newFrameMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.newFrameMenuActionPerformed(evt);
            }
        });
        exportMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.control.exportSettings();
            }
        });
        closeTabMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.closeTabMenuActionPerformed();
            }
        });
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StigmataFrame.this.closeMenuActionPerformed(evt);
            }
        });
        exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        return fileMenu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = Utility.createJMenu("helpmenu");
        JMenuItem about = Utility.createJMenuItem("about");
        JMenuItem license = Utility.createJMenuItem("license");
        JMenuItem help = Utility.createJMenuItem("helpmenu");
        JMenu laf = Utility.createJMenu("lookandfeel");
        this.expertmodeMenu = Utility.createJCheckBoxMenuItem("expertmenu");
        menu.add(about);
        menu.add(license);
        menu.add(help);
        menu.add(new JSeparator());
        menu.add(laf);
        menu.add(new JSeparator());
        menu.add(this.expertmodeMenu);
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.aboutMenuActionPerformed();
            }
        });
        license.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.licenseMenuActionPerformed();
            }
        });
        this.expertmodeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StigmataFrame.this.expertMenuActionPerformed(((JCheckBoxMenuItem)e.getSource()).getState());
            }
        });
        final UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < info.length; ++i) {
            final int index = i;
            JMenuItem item = new JMenuItem(info[i].getName());
            laf.add(item);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        UIManager.setLookAndFeel(info[index].getClassName());
                        SwingUtilities.updateComponentTreeUI(StigmataFrame.this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        help.setEnabled(false);
        return menu;
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmodeMenu.setState(expertmode);
    }

    private void expertMenuActionPerformed(boolean status) {
        this.control.setExpertMode(status);
    }

    private void aboutMenuActionPerformed() {
        Package p = this.getClass().getPackage();
        JPanel panel = new JPanel(new BorderLayout());
        JLabel logo = new JLabel(Utility.getIcon("stigmata.logo"));
        panel.add((Component)logo, "North");
        String aboutMessage = this.loadString("/resources/about.txt");
        aboutMessage = aboutMessage.replace("${implementation.version}", p.getImplementationVersion());
        aboutMessage = aboutMessage.replace("${implementation.vendor}", p.getImplementationVendor());
        aboutMessage = aboutMessage.replace("${implementation.title}", p.getImplementationTitle());
        JTextArea text = new JTextArea(aboutMessage);
        text.setEditable(false);
        text.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(text);
        panel.add((Component)scroll, "Center");
        JOptionPane.showMessageDialog(this, panel, Messages.getString("about.dialog.title"), 1);
    }

    private void licenseMenuActionPerformed() {
        JTextArea area = new JTextArea();
        area.setText(this.loadString("/META-INF/license.txt"));
        Font f = area.getFont();
        area.setFont(new Font("Monospaced", f.getStyle(), f.getSize()));
        area.setEditable(false);
        area.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(area);
        scroll.setPreferredSize(new Dimension(500, 300));
        JOptionPane.showMessageDialog(this, scroll, Messages.getString("license.dialog.title"), 1);
    }

    private void showExceptionMessage(Exception e) {
        if (e instanceof BirthmarkElementClassNotFoundException) {
            this.showClassNotFoundMessage((BirthmarkElementClassNotFoundException)e);
            return;
        }
        JTextArea area = new JTextArea(20, 60);
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        e.printStackTrace(out);
        if (e instanceof BirthmarkExtractionException) {
            out.println("Causes:");
            for (Throwable t : ((BirthmarkExtractionException)e).getCauses()) {
                t.printStackTrace(out);
            }
        }
        out.close();
        area.setText(writer.toString());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(Messages.getString("error.message.contactus")), "North");
        panel.add((Component)new JScrollPane(area), "Center");
        JOptionPane.showMessageDialog(this, panel, Messages.getString("error.dialog.title"), 2);
    }

    private void showClassNotFoundMessage(BirthmarkElementClassNotFoundException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><body><p>");
        sb.append(Messages.getString("error.message.classpath"));
        sb.append("</p><ul>");
        for (String name : e.getClassNames()) {
            sb.append("<li>").append(name).append("</li>");
        }
        sb.append("</ul></body></html>");
        JOptionPane.showMessageDialog(this, new String(sb), Messages.getString("error.dialog.title"), 2);
    }

    private String loadString(String loadFrom) {
        try {
            String line;
            URL url = this.getClass().getResource(loadFrom);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            out.close();
            in.close();
            return writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        frameList.remove(this);
        if (frameList.size() == 0) {
            System.exit(1);
        }
    }

    private void closeTabMenuActionPerformed() {
        int index = this.tabPane.getSelectedIndex();
        if (index == 0) {
            JOptionPane.showMessageDialog(this, Messages.getString("cannotclosecontroltab.dialog.message"), Messages.getString("cannotclosecontroltab.dialog.title"), 0);
        } else {
            this.tabPane.removeTabAt(index);
        }
    }

    private void closeMenuActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        frameList.remove(this);
        if (frameList.size() == 0) {
            System.exit(1);
        }
    }

    private void newFrameMenuActionPerformed(ActionEvent evt) {
        StigmataFrame frame = new StigmataFrame(this.stigmata, this.context);
        frame.setVisible(true);
    }
}

