/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelectablePane;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelection;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class BirthmarkSelectionCheckSetPane
extends BirthmarkSelectablePane
implements BirthmarkServiceListener {
    private static final long serialVersionUID = 3209854654743223453L;
    private StigmataFrame stigmata;
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private Set<String> selectedServices = new HashSet<String>();
    private Map<String, BirthmarkSelection> services;
    private boolean expertmode = false;
    private JPanel checks = new JPanel();

    public BirthmarkSelectionCheckSetPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initServices();
        stigmata.addBirthmarkServiceListener(this);
    }

    private void initLayouts() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.checks, "Center");
        JButton checkAll = Utility.createButton("checkall");
        JButton uncheckAll = Utility.createButton("uncheckall");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(checkAll);
        box.add(Box.createHorizontalGlue());
        box.add(uncheckAll);
        box.add(Box.createHorizontalGlue());
        this.add((Component)box, "South");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean flag = e.getActionCommand().equals("checkall");
                for (String key : BirthmarkSelectionCheckSetPane.this.services.keySet()) {
                    BirthmarkSelection le = (BirthmarkSelection)BirthmarkSelectionCheckSetPane.this.services.get(key);
                    le.setSelected(flag);
                    BirthmarkSelectionCheckSetPane.this.updateLayouts();
                    BirthmarkSelectionCheckSetPane.this.fireEvent();
                }
            }
        };
        checkAll.addActionListener(listener);
        uncheckAll.addActionListener(listener);
    }

    public void select(BirthmarkSpi service, boolean flag) {
        if (flag) {
            this.selectedServices.add(service.getType());
        } else {
            this.selectedServices.remove(service.getType());
        }
        this.fireEvent();
    }

    public void refresh() {
        this.initServices();
        this.updateLayouts();
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmode = expertmode;
        this.updateLayouts();
    }

    public boolean isExpertMode() {
        return this.expertmode;
    }

    public void reset() {
        this.selectedServices.clear();
        this.initServices();
        this.expertmode = false;
        this.updateLayouts();
        this.fireEvent();
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public String[] getServices() {
        String[] serviceArray = new String[this.services.size()];
        int index = 0;
        for (String key : this.services.keySet()) {
            BirthmarkSpi service = this.services.get(key).getService();
            serviceArray[index] = service.getType();
            ++index;
        }
        return serviceArray;
    }

    public String[] getSelectedServices() {
        return this.selectedServices.toArray(new String[this.selectedServices.size()]);
    }

    public void serviceAdded(BirthmarkSpi service) {
        if (this.services.get(service.getType()) == null) {
            BirthmarkSelection elem = new BirthmarkSelection(service);
            this.selectedServices.add(service.getType());
            this.services.put(service.getType(), elem);
        }
        this.updateLayouts();
        this.fireEvent();
    }

    public BirthmarkSpi getService(String type) {
        BirthmarkSelection elem = this.services.get(type);
        if (elem != null) {
            return elem.getService();
        }
        return null;
    }

    public boolean hasService(String type) {
        return this.services.get(type) != null;
    }

    public void serviceRemoved(BirthmarkSpi service) {
        BirthmarkSelection elem = this.services.get(service.getType());
        if (elem != null) {
            this.selectedServices.remove(service.getType());
            this.services.remove(service.getType());
        }
        this.updateLayouts();
        this.fireEvent();
    }

    private void fireEvent() {
        for (DataChangeListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }

    private void updateLayouts() {
        this.checks.removeAll();
        Dimension d = this.calculateDimension();
        this.checks.setLayout(new GridLayout(d.height, d.width));
        for (String key : this.services.keySet()) {
            final BirthmarkSelection elem = this.services.get(key);
            if (elem.isVisible(this.isExpertMode())) {
                JCheckBox check = new JCheckBox(elem.getService().getDisplayType());
                check.setSelected(elem.isSelected());
                check.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JCheckBox c = (JCheckBox)e.getSource();
                        if (c.isSelected()) {
                            BirthmarkSelectionCheckSetPane.this.selectedServices.add(elem.getService().getType());
                        } else {
                            BirthmarkSelectionCheckSetPane.this.selectedServices.remove(elem.getService().getType());
                        }
                        BirthmarkSelectionCheckSetPane.this.fireEvent();
                    }
                });
                this.checks.add(check);
            }
            if (elem.isVisible(this.isExpertMode()) && elem.isSelected()) {
                this.selectedServices.add(elem.getType());
                continue;
            }
            this.selectedServices.remove(elem.getType());
        }
        this.updateUI();
    }

    private void initServices() {
        BirthmarkSpi[] serviceArray = this.stigmata.getContext().getServices();
        this.services = new LinkedHashMap<String, BirthmarkSelection>();
        for (BirthmarkSpi service : serviceArray) {
            BirthmarkSelection elem = new BirthmarkSelection(service);
            this.services.put(service.getType(), elem);
        }
    }

    private Dimension calculateDimension() {
        int rows = 1;
        int cols = 0;
        for (String key : this.services.keySet()) {
            BirthmarkSelection selection = this.services.get(key);
            if (!selection.isVisible(this.isExpertMode())) continue;
            ++cols;
        }
        if (cols > 4) {
            rows = cols / 3;
            if (cols % 3 != 0) {
                ++rows;
            }
            cols = 3;
        }
        return new Dimension(cols, rows);
    }
}

